/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.security;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;

public class DebuggingJavaSecurityManager
extends SecurityManager {
    FilteringPrintStream fps = null;
    private boolean settingStream = false;
    private static boolean turnOnLogging = false;

    public DebuggingJavaSecurityManager() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    DebuggingJavaSecurityManager.this.fps = new FilteringPrintStream();
                    DebuggingJavaSecurityManager.this.setStreams();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    public void checkRead(String file) {
    }

    public void checkPermission(Permission perm) {
        turnOnLogging = false;
        try {
            if (System.err != this.fps) {
                this.setStreams();
            }
            super.checkPermission(perm);
        }
        catch (AccessControlException ace) {
            turnOnLogging = true;
            throw ace;
        }
    }

    private void setStreams() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    if (DebuggingJavaSecurityManager.this.settingStream) {
                        return null;
                    }
                    DebuggingJavaSecurityManager.this.settingStream = true;
                    System.err.println(" ");
                    System.err.println(" ");
                    System.err.println("*** Java Security Manager is the one for debugging.  DO NOT USE THIS IN PRODUCTION ****");
                    System.err.println(" ");
                    System.err.println(" ");
                    System.err.println(" ");
                    System.err.println(" ");
                    System.err.println("WE ARE SETTING THE error and output streams to FILTERINGPRINTSTREAM (Not for ***Production*** Use)");
                    if (DebuggingJavaSecurityManager.this.fps == null) {
                        DebuggingJavaSecurityManager.this.fps = new FilteringPrintStream();
                    }
                    System.setErr(DebuggingJavaSecurityManager.this.fps);
                    System.setOut(DebuggingJavaSecurityManager.this.fps);
                    System.err.println("Confirming that the error stream is set to FILTERINGPRINTSTREAM : " + (DebuggingJavaSecurityManager.this.fps == System.err));
                    DebuggingJavaSecurityManager.this.settingStream = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    private static class DummyOutputStream
    extends OutputStream {
        private DummyOutputStream() {
        }

        public void write(int b) throws IOException {
        }
    }

    private static class FilteringPrintStream
    extends PrintStream {
        private PrintStream ps = System.err;

        public FilteringPrintStream() throws FileNotFoundException {
            super(new DummyOutputStream());
        }

        public void println(String x) {
            if (!turnOnLogging) {
                if (x.contains("allowed")) {
                    return;
                }
                if (x.contains("domain that failed ProtectionDomain") || x.contains("Confirming") || x.contains("denied") || x.contains("Exception")) {
                    this.ps.println(x);
                }
            }
        }

        public void print(String s) {
            this.ps.print(s);
        }
    }
}

