/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.jdbc;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCUtil {
    private static final Log log = LogFactory.getLog(JDBCUtil.class);
    private static final String SQL_ERROR = "Error closing a resource: ";
    private static final String POSTGRES_NEXTVAL_SQL = "(SELECT nextval('%s_id_seq'::text))";
    private static final String ORACLE_NEXTVAL_SQL = "%s_id_seq.nextval";
    private static final String H2_NEXTVAL_SQL = "(SELECT nextval('%s_id_seq'))";

    public static void safeClose(Statement stm, ResultSet rs) {
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(stm);
    }

    public static void safeClose(Connection conn, Statement stm, ResultSet rs) {
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(stm);
        JDBCUtil.safeClose(conn);
    }

    public static void safeClose(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (Exception e) {
                log.error((Object)SQL_ERROR, (Throwable)e);
            }
        }
    }

    public static void safeClose(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception e) {
                log.error((Object)SQL_ERROR, (Throwable)e);
            }
        }
    }

    public static void safeClose(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception e) {
                log.error((Object)SQL_ERROR, (Throwable)e);
            }
        }
    }

    public static void bindNTimes(PreparedStatement ps, int[] values, int startingBinding) throws SQLException {
        for (int i = 0; i < values.length; ++i) {
            ps.setInt(startingBinding + i, values[i]);
        }
    }

    public static String transformQueryForMultipleInParameters(String query, String replaceable, int bindCount) {
        String replacement = JDBCUtil.generateInBinds(bindCount);
        return query.replace(replaceable, replacement);
    }

    public static String generateInBinds(int count) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                b.append(",");
            }
            b.append("?");
        }
        return b.toString();
    }

    public static String getNextValSql(Connection conn, String tableName) {
        String nextvalSql;
        block5: {
            try {
                DatabaseMetaData meta = conn.getMetaData();
                String name = meta.getDatabaseProductName().toLowerCase();
                if (name.contains("postgres")) {
                    nextvalSql = POSTGRES_NEXTVAL_SQL;
                    break block5;
                }
                if (name.contains("oracle")) {
                    nextvalSql = ORACLE_NEXTVAL_SQL;
                    break block5;
                }
                if (name.contains("h2")) {
                    nextvalSql = H2_NEXTVAL_SQL;
                    break block5;
                }
                JDBCUtil.safeClose(conn);
                throw new IllegalStateException("Unsupported database type: " + name);
            }
            catch (Exception e) {
                JDBCUtil.safeClose(conn);
                throw new IllegalStateException("Failed to determine database type.");
            }
        }
        nextvalSql = String.format(nextvalSql, tableName);
        return nextvalSql;
    }

    @Deprecated
    public static void safeClose(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception e) {
                log.error((Object)SQL_ERROR, (Throwable)e);
            }
        }
    }

    @Deprecated
    public static void safeClose(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception e) {
                log.error((Object)SQL_ERROR, (Throwable)e);
            }
        }
    }

    @Deprecated
    public static void safeClose(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception e) {
                log.error((Object)SQL_ERROR, (Throwable)e);
            }
        }
    }

    @Deprecated
    public static void safeClose(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (Exception e) {
                log.error((Object)SQL_ERROR, (Throwable)e);
            }
        }
    }
}

