/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50.deployment.metadata;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.common.resolvers.spi.EjbReferenceResolver;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentEntriesMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.wsf.common.injection.resolvers.ResourceReferenceResolver;
import org.jboss.wsf.container.jboss50.deployment.metadata.EJBBeanReferenceResolver;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.integration.WebServiceDeclaration;
import org.jboss.wsf.spi.deployment.integration.WebServiceDeployment;
import org.jboss.wsf.spi.metadata.injection.InjectionMetaData;
import org.jboss.wsf.spi.metadata.injection.InjectionsMetaData;
import org.jboss.wsf.spi.metadata.injection.ReferenceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InjectionMetaDataDeploymentAspect
extends DeploymentAspect {
    private static final ReferenceResolver RESOURCE_REFERENCE_RESOLVER = new ResourceReferenceResolver();
    private EjbReferenceResolver ejbReferenceResolver;

    public void create(Deployment dep) {
        block5: {
            Deployment.DeploymentType deploymentType;
            Map<Class<? extends Annotation>, ReferenceResolver> resolvers;
            LinkedList<InjectionMetaData> injectionMD;
            DeploymentUnit unit;
            block4: {
                super.create(dep);
                unit = (DeploymentUnit)dep.getAttachment(DeploymentUnit.class);
                if (unit == null) {
                    throw new IllegalStateException("DeploymentUnit not found");
                }
                JBossWebMetaData webMD = (JBossWebMetaData)dep.getAttachment(JBossWebMetaData.class);
                if (webMD == null) {
                    throw new IllegalStateException("JBossWebMetaData not found");
                }
                injectionMD = new LinkedList<InjectionMetaData>();
                resolvers = this.createResolvers(unit);
                deploymentType = dep.getType();
                if (deploymentType != Deployment.DeploymentType.JAXWS_JSE) break block4;
                injectionMD.addAll(this.buildInjectionMetaData(webMD.getEnvironmentEntries()));
                for (Endpoint endpoint : dep.getService().getEndpoints()) {
                    InjectionsMetaData injectionsMD = new InjectionsMetaData(injectionMD, resolvers);
                    endpoint.addAttachment(InjectionsMetaData.class, (Object)injectionsMD);
                }
                break block5;
            }
            if (deploymentType != Deployment.DeploymentType.JAXWS_EJB3) break block5;
            JBossMetaData jbossMD = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
            JBossEnterpriseBeansMetaData jebMDs = jbossMD.getEnterpriseBeans();
            WebServiceDeployment webServiceDeployment = (WebServiceDeployment)unit.getAttachment(WebServiceDeployment.class);
            for (WebServiceDeclaration container : webServiceDeployment.getServiceEndpoints()) {
                if (!this.isWebServiceBean(container)) continue;
                String ejbName = container.getComponentName();
                EnvironmentEntriesMetaData ejbEnvEntries = ((JBossEnterpriseBeanMetaData)jebMDs.get(ejbName)).getEnvironmentEntries();
                injectionMD.addAll(this.buildInjectionMetaData(ejbEnvEntries));
                Endpoint endpoint = dep.getService().getEndpointByName(ejbName);
                InjectionsMetaData injectionsMD = new InjectionsMetaData(injectionMD, resolvers);
                endpoint.addAttachment(InjectionsMetaData.class, (Object)injectionsMD);
            }
        }
    }

    public void destroy(Deployment dep) {
        dep.getService().removeAttachment(InjectionMetaData.class);
        super.destroy(dep);
    }

    private Map<Class<? extends Annotation>, ReferenceResolver> createResolvers(DeploymentUnit unit) {
        HashMap<Class<? extends Annotation>, ReferenceResolver> resolvers = new HashMap<Class<? extends Annotation>, ReferenceResolver>();
        resolvers.put(Resource.class, RESOURCE_REFERENCE_RESOLVER);
        resolvers.put((Class<? extends Annotation>)EJB.class, (ReferenceResolver)new EJBBeanReferenceResolver(unit, this.getEjbReferenceResolver()));
        return resolvers;
    }

    private List<InjectionMetaData> buildInjectionMetaData(EnvironmentEntriesMetaData envEntries) {
        if (envEntries == null || envEntries.size() == 0) {
            return Collections.emptyList();
        }
        EnvironmentEntryMetaData eeMD2 = null;
        LinkedList<InjectionMetaData> retVal = new LinkedList<InjectionMetaData>();
        String envEntryName = null;
        String envEntryValue = null;
        String targetClass = null;
        String targetName = null;
        String valueClass = null;
        for (EnvironmentEntryMetaData eeMD2 : envEntries) {
            envEntryName = eeMD2.getEnvEntryName();
            envEntryValue = eeMD2.getValue();
            valueClass = eeMD2.getType();
            Set injectionTargets = eeMD2.getInjectionTargets();
            if (injectionTargets == null || injectionTargets.size() <= 0) continue;
            for (ResourceInjectionTargetMetaData ritMD : injectionTargets) {
                targetClass = ritMD.getInjectionTargetClass();
                targetName = ritMD.getInjectionTargetName();
                InjectionMetaData injectionMD = new InjectionMetaData(targetClass, targetName, valueClass, envEntryName, envEntryValue != null);
                retVal.add(injectionMD);
            }
        }
        return retVal;
    }

    private boolean isWebServiceBean(WebServiceDeclaration container) {
        boolean isWebService = container.getAnnotation(WebService.class) != null;
        boolean isWebServiceProvider = container.getAnnotation(WebServiceProvider.class) != null;
        return isWebService || isWebServiceProvider;
    }

    public void setEjbReferenceResolver(EjbReferenceResolver resolver) {
        this.ejbReferenceResolver = resolver;
    }

    public EjbReferenceResolver getEjbReferenceResolver() {
        if (this.ejbReferenceResolver == null) {
            throw new IllegalStateException("No EjbReferenceResolver set by MC");
        }
        return this.ejbReferenceResolver;
    }
}

