/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.jboss.xnio.FailedIoFuture;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.IoHandlerFactory;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.channels.BoundServer;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.CommonOptions;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.UdpChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.management.UdpServerMBean;
import org.jboss.xnio.nio.FutureUdpChannel;
import org.jboss.xnio.nio.NioUdpServerConfig;
import org.jboss.xnio.nio.NioUdpSocketChannelImpl;
import org.jboss.xnio.nio.NioXnio;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NioUdpServer
implements BoundServer<SocketAddress, UdpChannel> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.xnio.nio.udp.server");
    private final NioXnio nioXnio;
    private final IoHandlerFactory<? super UdpChannel> handlerFactory;
    private final Executor executor;
    private final Object lock = new Object();
    private final Set<NioUdpSocketChannelImpl> boundChannels = new LinkedHashSet<NioUdpSocketChannelImpl>();
    private boolean closed;
    private Boolean reuseAddress;
    private Integer receiveBufferSize;
    private Integer sendBufferSize;
    private Integer trafficClass;
    private Boolean broadcast;
    private final Closeable mbeanHandle;
    private final AtomicLong globalBytesRead = new AtomicLong();
    private final AtomicLong globalBytesWritten = new AtomicLong();
    private final AtomicLong globalMessagesRead = new AtomicLong();
    private final AtomicLong globalMessagesWritten = new AtomicLong();
    protected static final Set<ChannelOption<?>> OPTIONS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NioUdpServer(NioUdpServerConfig config) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.nioXnio = config.getXnio();
            this.handlerFactory = config.getHandlerFactory();
            this.executor = config.getExecutor();
            this.reuseAddress = config.getReuseAddresses();
            this.receiveBufferSize = config.getReceiveBuffer();
            this.sendBufferSize = config.getSendBuffer();
            this.trafficClass = config.getTrafficClass();
            this.broadcast = config.getBroadcast();
            try {
                this.mbeanHandle = this.nioXnio.registerMBean(new MBean());
            }
            catch (NotCompliantMBeanException e) {
                throw new IOException("Cannot construct server mbean: " + e);
            }
        }
    }

    public <T> T getOption(ChannelOption<T> option) throws UnsupportedOptionException, IOException {
        if (CommonOptions.RECEIVE_BUFFER.equals(option)) {
            return option.getType().cast(this.receiveBufferSize);
        }
        if (CommonOptions.REUSE_ADDRESSES.equals(option)) {
            return option.getType().cast(this.reuseAddress);
        }
        if (CommonOptions.SEND_BUFFER.equals(option)) {
            return option.getType().cast(this.sendBufferSize);
        }
        if (CommonOptions.IP_TRAFFIC_CLASS.equals(option)) {
            return option.getType().cast(this.trafficClass);
        }
        if (CommonOptions.BROADCAST.equals(option)) {
            return option.getType().cast(this.broadcast);
        }
        throw new UnsupportedOptionException("Option not supported: " + option);
    }

    public Set<ChannelOption<?>> getOptions() {
        return OPTIONS;
    }

    public <T> Configurable setOption(ChannelOption<T> option, T value) throws IllegalArgumentException, IOException {
        if (!OPTIONS.contains(option)) {
            throw new UnsupportedOptionException("Option not supported: " + option);
        }
        if (CommonOptions.RECEIVE_BUFFER.equals(option)) {
            this.receiveBufferSize = (Integer)CommonOptions.RECEIVE_BUFFER.getType().cast(value);
            return this;
        }
        if (CommonOptions.REUSE_ADDRESSES.equals(option)) {
            this.reuseAddress = (Boolean)CommonOptions.REUSE_ADDRESSES.getType().cast(value);
            return this;
        }
        if (CommonOptions.SEND_BUFFER.equals(option)) {
            this.sendBufferSize = (Integer)CommonOptions.SEND_BUFFER.getType().cast(value);
            return this;
        }
        if (CommonOptions.IP_TRAFFIC_CLASS.equals(option)) {
            this.trafficClass = (Integer)CommonOptions.IP_TRAFFIC_CLASS.getType().cast(value);
            return this;
        }
        if (CommonOptions.BROADCAST.equals(option)) {
            this.broadcast = (Boolean)CommonOptions.BROADCAST.getType().cast(value);
            return this;
        }
        throw new IllegalStateException("Failed to set supported option: " + option);
    }

    public String toString() {
        return String.format("UDP server (NIO) <%s>", Integer.toHexString(this.hashCode()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static NioUdpServer create(NioUdpServerConfig config) throws IOException {
        NioUdpServer server = new NioUdpServer(config);
        boolean ok = false;
        try {
            SocketAddress[] addresses = config.getInitialAddresses();
            if (addresses != null) {
                for (SocketAddress address : addresses) {
                    server.bind(address).get();
                }
            }
            ok = true;
            log.trace("Successfully started UDP server");
            NioUdpServer nioUdpServer = server;
            return nioUdpServer;
        }
        finally {
            if (!ok) {
                IoUtils.safeClose((Closeable)((Object)server));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<UdpChannel> getChannels() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<UdpChannel>(this.boundChannels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoFuture<UdpChannel> bind(final SocketAddress address) {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.closed) {
                    throw new ClosedChannelException();
                }
                final DatagramChannel datagramChannel = DatagramChannel.open();
                datagramChannel.configureBlocking(false);
                DatagramSocket socket = datagramChannel.socket();
                if (this.broadcast != null) {
                    socket.setBroadcast(this.broadcast);
                }
                if (this.receiveBufferSize != null) {
                    socket.setReceiveBufferSize(this.receiveBufferSize);
                }
                if (this.sendBufferSize != null) {
                    socket.setSendBufferSize(this.sendBufferSize);
                }
                if (this.reuseAddress != null) {
                    socket.setReuseAddress(this.reuseAddress);
                }
                if (this.trafficClass != null) {
                    socket.setTrafficClass(this.trafficClass);
                }
                socket.bind(address);
                final IoHandler handler = this.handlerFactory.createHandler();
                final NioUdpSocketChannelImpl udpSocketChannel = this.createChannel(datagramChannel, (IoHandler<? super UdpChannel>)handler);
                final FutureUdpChannel futureUdpChannel = new FutureUdpChannel(udpSocketChannel, datagramChannel);
                this.boundChannels.add(udpSocketChannel);
                this.executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        block6: {
                            try {
                                handler.handleOpened((Channel)((Object)udpSocketChannel));
                                if (!futureUdpChannel.done()) {
                                    IoUtils.safeClose((Closeable)((Object)udpSocketChannel));
                                }
                                log.trace("Successfully bound to %s on %s", (Object)address, (Object)NioUdpServer.this);
                            }
                            catch (Throwable t) {
                                IoUtils.safeClose((Closeable)datagramChannel);
                                Object object = NioUdpServer.this.lock;
                                synchronized (object) {
                                    NioUdpServer.this.boundChannels.remove(udpSocketChannel);
                                }
                                IOException ioe = new IOException("Failed to open UDP channel: " + t.toString());
                                ioe.initCause(t);
                                if (futureUdpChannel.setException(ioe)) break block6;
                                log.trace((Throwable)ioe, "UDP channel open failed, but the operation was cancelled before the exception could be relayed", new Object[0]);
                            }
                        }
                    }
                });
                return futureUdpChannel;
            }
            catch (IOException e) {
                return new FailedIoFuture(e);
            }
        }
    }

    NioUdpSocketChannelImpl createChannel(DatagramChannel datagramChannel, IoHandler<? super UdpChannel> handler) throws IOException {
        return new NioUdpSocketChannelImpl(this.nioXnio, datagramChannel, handler, this.executor, this.globalBytesRead, this.globalBytesWritten, this.globalMessagesRead, this.globalMessagesWritten);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                log.trace("Closing %s", (Object)this);
                this.closed = true;
                Iterator<NioUdpSocketChannelImpl> it = this.boundChannels.iterator();
                while (it.hasNext()) {
                    IoUtils.safeClose((Closeable)((Closeable)((Object)it.next())));
                    it.remove();
                }
                IoUtils.safeClose((Closeable)this.mbeanHandle);
            }
        }
    }

    static {
        HashSet<ChannelOption> options = new HashSet<ChannelOption>();
        options.add(CommonOptions.RECEIVE_BUFFER);
        options.add(CommonOptions.REUSE_ADDRESSES);
        options.add(CommonOptions.SEND_BUFFER);
        options.add(CommonOptions.IP_TRAFFIC_CLASS);
        options.add(CommonOptions.BROADCAST);
        OPTIONS = Collections.unmodifiableSet(options);
    }

    private final class MBean
    extends StandardMBean
    implements UdpServerMBean {
        private MBean() throws NotCompliantMBeanException {
            super(UdpServerMBean.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UdpServerMBean.Channel[] getBoundChannels() {
            Object object = NioUdpServer.this.lock;
            synchronized (object) {
                UdpServerMBean.Channel[] channels = new UdpServerMBean.Channel[NioUdpServer.this.boundChannels.size()];
                int i = 0;
                for (final NioUdpSocketChannelImpl channel : NioUdpServer.this.boundChannels) {
                    channels[i++] = new UdpServerMBean.Channel(){

                        public long getBytesRead() {
                            return channel.bytesRead.get();
                        }

                        public long getBytesWritten() {
                            return channel.bytesWritten.get();
                        }

                        public long getMessagesRead() {
                            return channel.messagesRead.get();
                        }

                        public long getMessagesWritten() {
                            return channel.messagesWritten.get();
                        }

                        public SocketAddress getBindAddress() {
                            return channel.getLocalAddress();
                        }

                        public void close() {
                            IoUtils.safeClose((Closeable)((Object)channel));
                        }
                    };
                }
                return channels;
            }
        }

        public long getBytesRead() {
            return NioUdpServer.this.globalBytesRead.get();
        }

        public long getBytesWritten() {
            return NioUdpServer.this.globalBytesWritten.get();
        }

        public long getMessagesRead() {
            return NioUdpServer.this.globalMessagesRead.get();
        }

        public long getMessagesWritten() {
            return NioUdpServer.this.globalMessagesWritten.get();
        }

        public void close() {
            IoUtils.safeClose((Closeable)((Object)NioUdpServer.this));
        }
    }
}

