/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.session.mgt;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.session.mgt.SessionValidationScheduler;
import org.jsecurity.session.mgt.ValidatingSessionManager;

public class ExecutorServiceSessionValidationScheduler
implements SessionValidationScheduler,
Runnable {
    private static final Log log = LogFactory.getLog(ExecutorServiceSessionValidationScheduler.class);
    ValidatingSessionManager sessionManager;
    private ScheduledExecutorService service;
    private long interval = 3600000L;
    private boolean enabled = false;

    public ExecutorServiceSessionValidationScheduler() {
    }

    public ExecutorServiceSessionValidationScheduler(ValidatingSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public ValidatingSessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setSessionManager(ValidatingSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void enableSessionValidation() {
        if (this.interval > 0L) {
            this.service = Executors.newSingleThreadScheduledExecutor();
            this.service.scheduleAtFixedRate(this, this.interval, this.interval, TimeUnit.MILLISECONDS);
            this.enabled = true;
        }
    }

    public void run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Executing session validation...");
        }
        long startTime = System.currentTimeMillis();
        this.sessionManager.validateSessions();
        long stopTime = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Session validation completed successfully in " + (stopTime - startTime) + " milliseconds."));
        }
    }

    public void disableSessionValidation() {
        this.service.shutdownNow();
        this.enabled = false;
    }
}

