/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.web.session;

import java.io.Serializable;
import java.net.InetAddress;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.authz.AuthorizationException;
import org.jsecurity.authz.HostUnauthorizedException;
import org.jsecurity.session.InvalidSessionException;
import org.jsecurity.session.Session;
import org.jsecurity.session.mgt.DefaultSessionManager;
import org.jsecurity.web.WebUtils;
import org.jsecurity.web.attr.CookieAttribute;
import org.jsecurity.web.attr.RequestParamAttribute;
import org.jsecurity.web.servlet.JSecurityHttpServletRequest;
import org.jsecurity.web.session.WebSessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWebSessionManager
extends DefaultSessionManager
implements WebSessionManager {
    private static final Log log = LogFactory.getLog(DefaultWebSessionManager.class);
    private boolean validateRequestOrigin = false;
    protected CookieAttribute<Serializable> sessionIdCookieAttribute = null;
    protected RequestParamAttribute<Serializable> sessionIdRequestParamAttribute = null;

    public DefaultWebSessionManager() {
        this.ensureCookieSessionIdStore();
        this.ensureRequestParamSessionIdStore();
    }

    public CookieAttribute<Serializable> getSessionIdCookieAttribute() {
        return this.sessionIdCookieAttribute;
    }

    public void setSessionIdCookieAttribute(CookieAttribute<Serializable> sessionIdCookieAttribute) {
        this.sessionIdCookieAttribute = sessionIdCookieAttribute;
    }

    public RequestParamAttribute<Serializable> getSessionIdRequestParamAttribute() {
        return this.sessionIdRequestParamAttribute;
    }

    public void setSessionIdRequestParamAttribute(RequestParamAttribute<Serializable> sessionIdRequestParamAttribute) {
        this.sessionIdRequestParamAttribute = sessionIdRequestParamAttribute;
    }

    public boolean isValidateRequestOrigin() {
        return this.validateRequestOrigin;
    }

    public void setValidateRequestOrigin(boolean validateRequestOrigin) {
        this.validateRequestOrigin = validateRequestOrigin;
    }

    public void setSessionIdCookieName(String name) {
        this.getSessionIdCookieAttribute().setName(name);
    }

    public void setSessionIdCookiePath(String path) {
        this.getSessionIdCookieAttribute().setPath(path);
    }

    public void setSessionIdCookieMaxAge(int maxAge) {
        this.getSessionIdCookieAttribute().setMaxAge(maxAge);
    }

    public void setSessionIdCookieSecure(boolean secure) {
        this.getSessionIdCookieAttribute().setSecure(secure);
    }

    protected void ensureCookieSessionIdStore() {
        CookieAttribute<Serializable> cookieStore = this.getSessionIdCookieAttribute();
        if (cookieStore == null) {
            cookieStore = new CookieAttribute("JSESSIONID");
            cookieStore.setCheckRequestParams(false);
            this.setSessionIdCookieAttribute(cookieStore);
        }
    }

    protected void ensureRequestParamSessionIdStore() {
        RequestParamAttribute<Serializable> reqParamStore = this.getSessionIdRequestParamAttribute();
        if (reqParamStore == null) {
            reqParamStore = new RequestParamAttribute("JSESSIONID");
            this.setSessionIdRequestParamAttribute(reqParamStore);
        }
    }

    protected void validateSessionOrigin(ServletRequest request, Session session) throws HostUnauthorizedException {
        InetAddress requestIp = WebUtils.getInetAddress(request);
        InetAddress originIp = session.getHostAddress();
        Serializable sessionId = session.getId();
        if (originIp == null) {
            if (requestIp != null) {
                String msg = "No IP Address was specified when creating session with id [" + sessionId + "].  Attempting to access session from " + "IP [" + requestIp + "].  Origin IP and request IP must match.";
                throw new HostUnauthorizedException(msg);
            }
        } else if (requestIp != null) {
            if (!requestIp.equals(originIp)) {
                String msg = "Session with id [" + sessionId + "] originated from [" + originIp + "], but the current HttpServletRequest originated " + "from [" + requestIp + "].  Disallowing session access: " + "session origin and request origin must match to allow access.";
                throw new HostUnauthorizedException(msg);
            }
        } else {
            String msg = "No IP Address associated with the current HttpServletRequest.  Session with id [" + sessionId + "] originated from " + "[" + originIp + "].  Request IP must match the session's origin " + "IP in order to gain access to that session.";
            throw new HostUnauthorizedException(msg);
        }
    }

    protected void storeSessionId(Serializable currentId, ServletRequest request, ServletResponse response) {
        if (currentId == null) {
            String msg = "sessionId cannot be null when persisting for subsequent requests.";
            throw new IllegalArgumentException(msg);
        }
        Serializable existingId = this.retrieveSessionId(request, response);
        if (existingId == null || !currentId.equals(existingId)) {
            this.getSessionIdCookieAttribute().storeValue(currentId, request, response);
        }
    }

    protected Serializable retrieveSessionId(ServletRequest request, ServletResponse response) {
        CookieAttribute<Serializable> cookieSessionIdAttribute = this.getSessionIdCookieAttribute();
        Serializable id = (Serializable)cookieSessionIdAttribute.retrieveValue(request, response);
        if (id != null) {
            request.setAttribute(JSecurityHttpServletRequest.REFERENCED_SESSION_ID_SOURCE, (Object)"cookie");
        } else {
            id = (Serializable)this.getSessionIdRequestParamAttribute().retrieveValue(request, response);
            if (id != null) {
                request.setAttribute(JSecurityHttpServletRequest.REFERENCED_SESSION_ID_SOURCE, (Object)"url");
            }
        }
        return id;
    }

    @Override
    public Serializable start(InetAddress hostAddress) throws HostUnauthorizedException, IllegalArgumentException {
        ServletRequest request = WebUtils.getRequiredServletRequest();
        ServletResponse response = WebUtils.getRequiredServletResponse();
        return this.start(request, response, hostAddress);
    }

    protected Serializable start(ServletRequest request, ServletResponse response, InetAddress inetAddress) {
        Serializable sessionId = super.start(inetAddress);
        this.storeSessionId(sessionId, request, response);
        request.removeAttribute(JSecurityHttpServletRequest.REFERENCED_SESSION_ID_SOURCE);
        request.setAttribute(JSecurityHttpServletRequest.REFERENCED_SESSION_IS_NEW, (Object)Boolean.TRUE);
        return sessionId;
    }

    @Override
    public Session retrieveSession(Serializable sessionId) throws InvalidSessionException, AuthorizationException {
        if (sessionId != null) {
            return super.retrieveSession(sessionId);
        }
        ServletRequest request = WebUtils.getRequiredServletRequest();
        ServletResponse response = WebUtils.getRequiredServletResponse();
        return this.getSession(request, response);
    }

    @Override
    public final Session getSession(ServletRequest request, ServletResponse response) throws InvalidSessionException, AuthorizationException {
        Session session;
        try {
            session = this.doGetSession(request, response);
        }
        catch (InvalidSessionException ise) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Request Session is invalid, message: [" + ise.getMessage() + "].  Removing any " + "associated session cookie..."));
            }
            this.getSessionIdCookieAttribute().removeValue(request, response);
            session = this.handleInvalidSession(request, response, ise);
        }
        return session;
    }

    protected Session doGetSession(ServletRequest request, ServletResponse response) {
        Session session = null;
        Serializable sessionId = this.retrieveSessionId(request, response);
        if (sessionId != null) {
            request.setAttribute(JSecurityHttpServletRequest.REFERENCED_SESSION_ID, (Object)sessionId);
            session = super.retrieveSession(sessionId);
            if (this.isValidateRequestOrigin()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Validating request origin against session origin");
                }
                this.validateSessionOrigin(request, session);
            }
            if (session != null) {
                request.setAttribute(JSecurityHttpServletRequest.REFERENCED_SESSION_ID_IS_VALID, (Object)Boolean.TRUE);
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)"No JSecurity session id associated with the given HttpServletRequest.  A Session will not be returned.");
        }
        return session;
    }

    protected Session handleInvalidSession(ServletRequest request, ServletResponse response, InvalidSessionException ise) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Sesssion associated with the current request is nonexistent or invalid.  Returning null.");
        }
        return null;
    }

    @Override
    protected void onStop(Session session) {
        super.onStop(session);
        ServletRequest request = WebUtils.getRequiredServletRequest();
        ServletResponse response = WebUtils.getRequiredServletResponse();
        this.getSessionIdCookieAttribute().removeValue(request, response);
    }
}

