/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor;

import org.jboss.monitor.JBossMonitor;
import org.jboss.monitor.ThresholdMonitorMBean;
import org.jboss.monitor.ThresholdNotification;
import org.jboss.util.NestedRuntimeException;

public class ThresholdMonitor
extends JBossMonitor
implements ThresholdMonitorMBean,
Runnable {
    protected Number thresholdValue;
    protected int compareTo;
    protected Class attributeClass;

    protected void parseThresholdValue() {
        if (this.attributeClass.equals(Long.class)) {
            this.thresholdValue = new Long(Long.parseLong(this.thresholdString == null ? "0" : this.thresholdString));
            return;
        }
        if (this.attributeClass.equals(Integer.class)) {
            this.thresholdValue = new Integer(Integer.parseInt(this.thresholdString == null ? "0" : this.thresholdString));
            return;
        }
        if (this.attributeClass.equals(Double.class)) {
            this.thresholdValue = new Double(Double.parseDouble(this.thresholdString == null ? "0" : this.thresholdString));
            return;
        }
        if (this.attributeClass.equals(Float.class)) {
            this.thresholdValue = new Float(Float.parseFloat(this.thresholdString == null ? "0" : this.thresholdString));
            return;
        }
        if (this.attributeClass.equals(Short.class)) {
            this.thresholdValue = new Short(Short.parseShort(this.thresholdString == null ? "0" : this.thresholdString));
            return;
        }
        if (this.attributeClass.equals(Byte.class)) {
            this.thresholdValue = new Byte(Byte.parseByte(this.thresholdString == null ? "0" : this.thresholdString));
            return;
        }
        throw new RuntimeException("Failed to parse threshold string: " + this.thresholdString + " attributeClass: " + this.attributeClass);
    }

    protected int compare(Object value) {
        this.parseThresholdValue();
        if (this.attributeClass.equals(Long.class)) {
            return ((Long)this.thresholdValue).compareTo((Long)value);
        }
        if (this.attributeClass.equals(Integer.class)) {
            return ((Integer)this.thresholdValue).compareTo((Integer)value);
        }
        if (this.attributeClass.equals(Double.class)) {
            return ((Double)this.thresholdValue).compareTo((Double)value);
        }
        if (this.attributeClass.equals(Float.class)) {
            return ((Float)this.thresholdValue).compareTo((Float)value);
        }
        if (this.attributeClass.equals(Short.class)) {
            return ((Short)this.thresholdValue).compareTo((Short)value);
        }
        if (this.attributeClass.equals(Byte.class)) {
            return ((Byte)this.thresholdValue).compareTo((Byte)value);
        }
        throw new RuntimeException("Failed to compare threshold, unknown type");
    }

    protected void startService() throws Exception {
        Object val = this.getServer().getAttribute(this.observedObject, this.attribute);
        this.attributeClass = val.getClass();
        super.startService();
    }

    protected void testThreshold() {
        if (this.alertSent) {
            return;
        }
        Object value = null;
        try {
            value = this.getServer().getAttribute(this.observedObject, this.attribute);
            if (this.compare(value) != this.compareTo) {
                return;
            }
        }
        catch (Exception e) {
            throw new NestedRuntimeException("Failed to compare threshold, mbean failure", (Throwable)e);
        }
        this.alertSent = true;
        this.triggerTime = System.currentTimeMillis();
        this.triggeredAttributeValue = value;
        ThresholdNotification notification = new ThresholdNotification(this.monitorName, this.getServiceName(), this.observedObject, this.attribute, (Number)value, this.thresholdValue, this.getNextNotificationSequenceNumber());
        this.sendNotification(notification);
    }

    public int getCompareTo() {
        return this.compareTo;
    }

    public void setCompareTo(int compare) {
        this.compareTo = compare;
    }

    public Number getThresholdValue() {
        return this.thresholdValue;
    }

    public void setThreshold(String val) {
        this.thresholdString = val;
    }
}

