/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.connector.invoker;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.jmx.adaptor.rmi.RMINotificationListener;
import org.jboss.jmx.connector.invoker.InvokerAdaptorServiceMBean;
import org.jboss.jmx.connector.invoker.SecurityActions;
import org.jboss.jmx.connector.invoker.client.InvokerAdaptorException;
import org.jboss.security.SecurityContext;
import org.jboss.system.Registry;
import org.jboss.system.ServiceMBeanSupport;

public class InvokerAdaptorService
extends ServiceMBeanSupport
implements InvokerAdaptorServiceMBean {
    private ObjectName mbeanRegistry;
    private Map marshalledInvocationMapping = new HashMap();
    private Class[] exportedInterfaces;
    private HashSet addNotificationListeners = new HashSet();
    private HashSet removeNotificationListeners = new HashSet();
    protected HashMap remoteListeners = new HashMap();

    public Class[] getExportedInterfaces() {
        return this.exportedInterfaces;
    }

    public void setExportedInterfaces(Class[] exportedInterfaces) {
        this.exportedInterfaces = exportedInterfaces;
    }

    protected void startService() throws Exception {
        HashMap<Long, Method> tmpMap = new HashMap<Long, Method>(61);
        for (int n = 0; n < this.exportedInterfaces.length; ++n) {
            Class[] sig;
            Class iface = this.exportedInterfaces[n];
            Method[] methods = iface.getMethods();
            for (int m = 0; m < methods.length; ++m) {
                Method method = methods[m];
                Long hash = new Long(MarshalledInvocation.calculateHash((Method)method));
                tmpMap.put(hash, method);
            }
            try {
                sig = new Class[]{ObjectName.class, RMINotificationListener.class, NotificationFilter.class, Object.class};
                Method addNotificationListener = iface.getMethod("addNotificationListener", sig);
                this.addNotificationListeners.add(addNotificationListener);
            }
            catch (Exception e) {
                this.log.debug((Object)(iface + "No addNotificationListener(ObjectName, RMINotificationListener)"));
            }
            try {
                sig = new Class[]{ObjectName.class, RMINotificationListener.class};
                Method removeNotificationListener = iface.getMethod("removeNotificationListener", sig);
                this.removeNotificationListeners.add(removeNotificationListener);
                continue;
            }
            catch (Exception e) {
                this.log.debug((Object)(iface + "No removeNotificationListener(ObjectName, RMINotificationListener)"));
            }
        }
        this.marshalledInvocationMapping = Collections.unmodifiableMap(tmpMap);
        Registry.bind((Object)new Integer(this.serviceName.hashCode()), (Object)this.serviceName);
    }

    protected void stopService() throws Exception {
        if (this.exportedInterfaces != null) {
            for (int n = 0; n < this.exportedInterfaces.length; ++n) {
                MarshalledInvocation.removeHashes((Class)this.exportedInterfaces[n]);
            }
        }
        this.marshalledInvocationMapping = null;
        this.remoteListeners.clear();
        Registry.unbind((Object)new Integer(this.serviceName.hashCode()));
    }

    public Map getMethodMap() {
        return this.marshalledInvocationMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Invocation invocation) throws Exception {
        try {
            Object object;
            ClassLoader oldCL = SecurityActions.getContextClassLoader();
            ClassLoader newCL = null;
            ObjectName objectName = (ObjectName)invocation.getValue((Object)"JMX_OBJECT_NAME");
            if (objectName != null) {
                newCL = this.server.getClassLoaderFor(objectName);
            }
            if (newCL != null && newCL != oldCL) {
                SecurityActions.setContextClassLoader(newCL);
            }
            SecurityContext previousSecurityContext = SecurityActions.getSecurityContext();
            try {
                Object value;
                block19: {
                    if (invocation instanceof MarshalledInvocation) {
                        MarshalledInvocation mi = (MarshalledInvocation)invocation;
                        mi.setMethodMap(this.marshalledInvocationMapping);
                    }
                    Method method = invocation.getMethod();
                    Object[] args = invocation.getArguments();
                    Principal principal = invocation.getPrincipal();
                    Object credential = invocation.getCredential();
                    value = null;
                    SecurityContext sc = SecurityActions.createSecurityContext("other");
                    SecurityActions.setSecurityContext(sc);
                    SecurityActions.pushSubjectContext(principal, credential, null);
                    try {
                        Object name;
                        if (this.addNotificationListeners.contains(method)) {
                            name = (ObjectName)args[0];
                            RMINotificationListener listener = (RMINotificationListener)args[1];
                            NotificationFilter filter = (NotificationFilter)args[2];
                            Object handback = args[3];
                            this.addNotificationListener((ObjectName)name, listener, filter, handback);
                            break block19;
                        }
                        if (this.removeNotificationListeners.contains(method)) {
                            name = (ObjectName)args[0];
                            RMINotificationListener listener = (RMINotificationListener)args[1];
                            this.removeNotificationListener((ObjectName)name, listener);
                        } else {
                            name = method.getName();
                            Class<?>[] paramTypes = method.getParameterTypes();
                            Method mbeanServerMethod = MBeanServer.class.getMethod((String)name, paramTypes);
                            value = mbeanServerMethod.invoke((Object)this.server, args);
                        }
                    }
                    catch (InvocationTargetException e) {
                        Throwable t = e.getTargetException();
                        if (t instanceof Exception) {
                            throw (Exception)t;
                        }
                        throw new UndeclaredThrowableException(t, method.toString());
                    }
                }
                object = value;
                Object var17_22 = null;
            }
            catch (Throwable throwable) {
                Object var17_23 = null;
                SecurityActions.popSubjectContext();
                if (previousSecurityContext != null) {
                    SecurityActions.setSecurityContext(previousSecurityContext);
                } else {
                    SecurityActions.clearSecurityContext();
                }
                if (newCL != null && newCL != oldCL) {
                    SecurityActions.setContextClassLoader(oldCL);
                }
                throw throwable;
            }
            SecurityActions.popSubjectContext();
            if (previousSecurityContext != null) {
                SecurityActions.setSecurityContext(previousSecurityContext);
            } else {
                SecurityActions.clearSecurityContext();
            }
            if (newCL != null && newCL != oldCL) {
                SecurityActions.setContextClassLoader(oldCL);
            }
            return object;
        }
        catch (Throwable t) {
            throw new InvokerAdaptorException(t);
        }
    }

    public void addNotificationListener(ObjectName name, RMINotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, RemoteException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("addNotificationListener, name=" + name + ", listener=" + listener));
        }
        NotificationListenerDelegate delegate = new NotificationListenerDelegate(listener, name);
        this.remoteListeners.put(listener, delegate);
        this.getServer().addNotificationListener(name, delegate, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, RMINotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, RemoteException {
        NotificationListenerDelegate delegate;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("removeNotificationListener, name=" + name + ", listener=" + listener));
        }
        if ((delegate = (NotificationListenerDelegate)this.remoteListeners.remove(listener)) == null) {
            throw new ListenerNotFoundException("No listener matches: " + listener);
        }
        this.getServer().removeNotificationListener(name, delegate);
    }

    private class NotificationListenerDelegate
    implements NotificationListener {
        private RMINotificationListener client;
        private ObjectName targetName;

        public NotificationListenerDelegate(RMINotificationListener client, ObjectName targetName) {
            this.client = client;
            this.targetName = targetName;
        }

        public void handleNotification(Notification notification, Object handback) {
            try {
                if (InvokerAdaptorService.this.log.isTraceEnabled()) {
                    InvokerAdaptorService.this.log.trace((Object)("Sending notification to client, event:" + notification));
                }
                this.client.handleNotification(notification, handback);
            }
            catch (Throwable t) {
                InvokerAdaptorService.this.log.debug((Object)"Failed to notify client, unregistering listener", t);
                try {
                    InvokerAdaptorService.this.removeNotificationListener(this.targetName, this.client);
                }
                catch (Exception e) {
                    InvokerAdaptorService.this.log.debug((Object)"Failed to unregister listener", (Throwable)e);
                }
            }
        }
    }
}

