/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.util;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.jboss.security.xacml.util.Base64;

public class PBEUtils {
    public static byte[] encode(byte[] secret, String cipherAlgorithm, SecretKey cipherKey, PBEParameterSpec cipherSpec) throws Exception {
        Cipher cipher = Cipher.getInstance(cipherAlgorithm);
        cipher.init(1, (Key)cipherKey, cipherSpec);
        byte[] encoding = cipher.doFinal(secret);
        return encoding;
    }

    public static String encode64(byte[] secret, String cipherAlgorithm, SecretKey cipherKey, PBEParameterSpec cipherSpec) throws Exception {
        byte[] encoding = PBEUtils.encode(secret, cipherAlgorithm, cipherKey, cipherSpec);
        String b64 = Base64.encodeBytes(encoding);
        return b64;
    }

    public static byte[] decode(byte[] secret, String cipherAlgorithm, SecretKey cipherKey, PBEParameterSpec cipherSpec) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(cipherAlgorithm);
        cipher.init(2, (Key)cipherKey, cipherSpec);
        byte[] decode = cipher.doFinal(secret);
        return decode;
    }

    public static String decode64(String secret, String cipherAlgorithm, SecretKey cipherKey, PBEParameterSpec cipherSpec) throws GeneralSecurityException, UnsupportedEncodingException {
        byte[] encoding = Base64.decode(secret);
        byte[] decode = PBEUtils.decode(encoding, cipherAlgorithm, cipherKey, cipherSpec);
        return new String(decode, "UTF-8");
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.err.println("Encrypt a passwordUsage: PBEUtils salt count password salt : the Salt  count : the IterationCount  password : the plaintext password that should be encrypted");
            throw new RuntimeException(" ERROR: please see format above");
        }
        byte[] salt = args[0].substring(0, 8).getBytes();
        int count = Integer.parseInt(args[1]);
        char[] password = "somearbitrarycrazystringthatdoesnotmatter".toCharArray();
        byte[] passwordToEncode = args[2].getBytes("UTF-8");
        PBEParameterSpec cipherSpec = new PBEParameterSpec(salt, count);
        PBEKeySpec keySpec = new PBEKeySpec(password);
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBEwithMD5andDES");
        SecretKey cipherKey = factory.generateSecret(keySpec);
        String encodedPassword = PBEUtils.encode64(passwordToEncode, "PBEwithMD5andDES", cipherKey, cipherSpec);
        System.err.println("Encoded password: MASK-" + encodedPassword);
    }
}

