/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat;

import org.hibernate.stat.CategorizedStatistics;

public class QueryStatistics
extends CategorizedStatistics {
    long cacheHitCount;
    long cacheMissCount;
    long cachePutCount;
    private long executionCount;
    private long executionRowCount;
    private long executionAvgTime;
    private long executionMaxTime;
    private long executionMinTime = Long.MAX_VALUE;

    QueryStatistics(String query) {
        super(query);
    }

    public long getExecutionCount() {
        return this.executionCount;
    }

    public long getCacheHitCount() {
        return this.cacheHitCount;
    }

    public long getCachePutCount() {
        return this.cachePutCount;
    }

    public long getCacheMissCount() {
        return this.cacheMissCount;
    }

    public long getExecutionRowCount() {
        return this.executionRowCount;
    }

    public long getExecutionAvgTime() {
        return this.executionAvgTime;
    }

    public long getExecutionMaxTime() {
        return this.executionMaxTime;
    }

    public long getExecutionMinTime() {
        return this.executionMinTime;
    }

    void executed(long rows, long time) {
        if (time < this.executionMinTime) {
            this.executionMinTime = time;
        }
        if (time > this.executionMaxTime) {
            this.executionMaxTime = time;
        }
        this.executionAvgTime = (this.executionAvgTime * this.executionCount + time) / (this.executionCount + 1L);
        ++this.executionCount;
        this.executionRowCount += rows;
    }

    public String toString() {
        return "QueryStatistics" + "[cacheHitCount=" + this.cacheHitCount + ",cacheMissCount=" + this.cacheMissCount + ",cachePutCount=" + this.cachePutCount + ",executionCount=" + this.executionCount + ",executionRowCount=" + this.executionRowCount + ",executionAvgTime=" + this.executionAvgTime + ",executionMaxTime=" + this.executionMaxTime + ",executionMinTime=" + this.executionMinTime + ']';
    }
}

