/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.resolver;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DerbyDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.InformixDialect;
import org.hibernate.dialect.IngresDialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.Oracle10gDialect;
import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.dialect.Oracle9iDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.SybaseASE15Dialect;
import org.hibernate.dialect.resolver.AbstractDialectResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardDialectResolver
extends AbstractDialectResolver {
    private static final Logger log = LoggerFactory.getLogger(StandardDialectResolver.class);

    @Override
    protected Dialect resolveDialectInternal(DatabaseMetaData metaData) throws SQLException {
        String databaseName = metaData.getDatabaseProductName();
        int databaseMajorVersion = metaData.getDatabaseMajorVersion();
        if ("HSQL Database Engine".equals(databaseName)) {
            return new HSQLDialect();
        }
        if ("H2".equals(databaseName)) {
            return new H2Dialect();
        }
        if ("MySQL".equals(databaseName)) {
            return new MySQLDialect();
        }
        if ("PostgreSQL".equals(databaseName)) {
            return new PostgreSQLDialect();
        }
        if ("Apache Derby".equals(databaseName)) {
            return new DerbyDialect();
        }
        if ("ingres".equalsIgnoreCase(databaseName)) {
            return new IngresDialect();
        }
        if (databaseName.startsWith("Microsoft SQL Server")) {
            return new SQLServerDialect();
        }
        if ("Sybase SQL Server".equals(databaseName) || "Adaptive Server Enterprise".equals(databaseName)) {
            return new SybaseASE15Dialect();
        }
        if ("Informix Dynamic Server".equals(databaseName)) {
            return new InformixDialect();
        }
        if (databaseName.startsWith("DB2/")) {
            return new DB2Dialect();
        }
        if ("Oracle".equals(databaseName)) {
            switch (databaseMajorVersion) {
                case 11: {
                    log.warn("Oracle 11g is not yet fully supported; using 10g dialect");
                    return new Oracle10gDialect();
                }
                case 10: {
                    return new Oracle10gDialect();
                }
                case 9: {
                    return new Oracle9iDialect();
                }
                case 8: {
                    return new Oracle8iDialect();
                }
            }
            log.warn("unknown Oracle major version [" + databaseMajorVersion + "]");
        }
        return null;
    }
}

