/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.param;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.param.AbstractExplicitParameterSpecification;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.type.Type;

public class PositionalParameterSpecification
extends AbstractExplicitParameterSpecification
implements ParameterSpecification {
    private final int hqlPosition;

    public PositionalParameterSpecification(int sourceLine, int sourceColumn, int hqlPosition) {
        super(sourceLine, sourceColumn);
        this.hqlPosition = hqlPosition;
    }

    @Override
    public int bind(PreparedStatement statement, QueryParameters qp, SessionImplementor session, int position) throws SQLException {
        Type type = qp.getPositionalParameterTypes()[this.hqlPosition];
        Object value = qp.getPositionalParameterValues()[this.hqlPosition];
        type.nullSafeSet(statement, value, position, session);
        return type.getColumnSpan(session.getFactory());
    }

    @Override
    public String renderDisplayInfo() {
        return "ordinal=" + this.hqlPosition + ", expectedType=" + this.getExpectedType();
    }

    public int getHqlPosition() {
        return this.hqlPosition;
    }
}

