/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.integration.password;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.log4j.Logger;
import org.jboss.security.integration.password.DocumentUtil;
import org.jboss.security.integration.password.KeyStoreUtil;
import org.jboss.security.integration.password.SecurityActions;
import org.jboss.security.integration.password.XMLEncryptionUtil;
import org.jboss.security.plugins.FilePassword;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PasswordMaskManagement {
    private Logger log = Logger.getLogger(PasswordMaskManagement.class);
    private Map<String, char[]> passwordMap = new HashMap<String, char[]>();
    private KeyStore keystore;
    private String alias = "jboss";
    private String passwordEncryptedFileName = "password/jboss_password_enc.dat";
    static String keystorePassEncFileName = "password/jboss_keystore_pass.dat";
    private String keystoreLocation = "password/password.keystore";
    KeyPair kp = null;
    private char[] storePass;

    public void setKeyStoreDetails(String location, String alias) throws Exception {
        if (location == null) {
            throw new IllegalArgumentException("location is null");
        }
        this.keystoreLocation = location;
        this.alias = alias;
        this.ensureKeyStore();
    }

    public void setKeyStoreDetails(String location, char[] storePass, String alias) throws Exception {
        if (location == null) {
            throw new IllegalArgumentException("location is null");
        }
        this.keystore = KeyStoreUtil.getKeyStore(location, storePass);
        this.storePass = storePass;
        this.alias = alias;
        this.load();
    }

    public void setKeyStoreLocation(String location) {
        if (location == null) {
            throw new IllegalArgumentException("location is null");
        }
        this.keystoreLocation = location;
    }

    public void setKeyStoreAlias(String alias) {
        if (alias == null) {
            throw new IllegalArgumentException("alias is null");
        }
        this.alias = alias;
    }

    public void setPasswordEncryptedFileName(String pefn) {
        this.passwordEncryptedFileName = pefn;
    }

    public void setKeyStorePasswordEncryptedFileName(String kpe) {
        keystorePassEncFileName = kpe;
    }

    boolean exists(String securityDomain) {
        return this.passwordMap.containsKey(securityDomain);
    }

    boolean keyStoreExists() {
        return this.keystore != null;
    }

    char[] getPassword(String securityDomain) throws Exception {
        if (this.keystore == null) {
            if (this.storePass == null) {
                this.ensureKeyStore();
            }
            if (this.passwordMap.size() == 0) {
                this.load();
            }
        }
        return this.passwordMap.get(securityDomain);
    }

    void storePassword(String securityDomain, char[] pass) {
        this.passwordMap.put(securityDomain, pass);
    }

    void removePassword(String domainToRemove) {
        this.passwordMap.remove(domainToRemove);
    }

    void load() throws Exception {
        Document doc = this.loadPasswordEncryptedDocument();
        if (doc == null) {
            this.log.trace((Object)(this.passwordEncryptedFileName + " does not exist"));
            return;
        }
        if (this.keystore == null) {
            System.out.println("Keystore is null. Please specify keystore below:");
            return;
        }
        PrivateKey privateKey = (PrivateKey)this.keystore.getKey(this.alias, this.storePass);
        if (privateKey == null) {
            throw new IllegalStateException("private key not found");
        }
        Document decryptedDoc = XMLEncryptionUtil.decrypt(doc, privateKey);
        NodeList nl = decryptedDoc.getDocumentElement().getElementsByTagName("entry");
        int len = nl != null ? nl.getLength() : 0;
        System.out.println("Loading domains [");
        for (int i = 0; i < len; ++i) {
            Element n = (Element)nl.item(i);
            String name = n.getAttribute("name");
            System.out.println(name + ",");
            this.passwordMap.put(name, n.getAttribute("pass").toCharArray());
        }
        System.out.println("]");
    }

    void store() throws Exception {
        if (this.keystore == null) {
            System.out.println("Keystore is null. Cannot store.");
            return;
        }
        StringBuilder builder = new StringBuilder();
        Document doc = DocumentUtil.createDocument();
        Element el = doc.createElementNS(null, "pass-map");
        doc.appendChild(el);
        System.out.println("Storing domains [");
        Set<Map.Entry<String, char[]>> entries = this.passwordMap.entrySet();
        for (Map.Entry<String, char[]> e : entries) {
            Element entry = doc.createElementNS(null, "entry");
            System.out.println(e.getKey() + ",");
            entry.setAttributeNS(null, "name", e.getKey());
            entry.setAttributeNS(null, "pass", new String(e.getValue()));
            el.appendChild(entry);
        }
        builder.append("</pass-map>");
        System.out.println("]");
        SecretKey skey = this.getSecretKey("AES", 128);
        PublicKey pk = KeyStoreUtil.getPublicKey(this.keystore, this.alias, this.storePass);
        if (pk == null) {
            throw new RuntimeException("public key is null");
        }
        XMLEncryptionUtil.encrypt(doc, skey, pk, 128);
        this.storePasswordEncryptedDocument(doc);
    }

    void ensurePasswordFile() throws Exception {
        block2: {
            try {
                this.loadPasswordEncryptedDocument();
            }
            catch (FileNotFoundException e) {
                File file = new File(this.passwordEncryptedFileName);
                if (file.exists()) break block2;
                file.createNewFile();
            }
        }
    }

    void ensureKeyStore() throws Exception {
        if (this.keystore == null) {
            if (this.keystoreLocation == null) {
                throw new IllegalStateException("KeyStore Location is null");
            }
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            URL keyEncFileURL = null;
            File keyfile = new File(keystorePassEncFileName);
            keyEncFileURL = !keyfile.exists() ? tcl.getResource(keystorePassEncFileName) : keyfile.toURL();
            FilePassword fp = null;
            try {
                fp = new FilePassword(keyEncFileURL.toString());
                this.storePass = fp.toCharArray();
            }
            catch (IOException eof) {
                throw new IllegalStateException("The Keystore Encrypted file not located:", eof);
            }
            if (this.storePass == null) {
                throw new IllegalStateException("Keystore password is null");
            }
            URL ksFileURL = null;
            File ksFile = new File(this.keystoreLocation);
            ksFileURL = !ksFile.exists() ? tcl.getResource(this.keystoreLocation) : ksFile.toURL();
            this.keystore = KeyStoreUtil.getKeyStore(ksFileURL, this.storePass);
        }
    }

    private SecretKey getSecretKey(String encAlgo, int keySize) throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(encAlgo);
        if (keySize == 0) {
            keySize = 128;
        }
        keyGenerator.init(keySize);
        return keyGenerator.generateKey();
    }

    private Document loadPasswordEncryptedDocument() throws Exception {
        Document doc = null;
        File docFile = new File(this.passwordEncryptedFileName);
        if (docFile == null || !docFile.exists()) {
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            InputStream is = tcl.getResourceAsStream(this.passwordEncryptedFileName);
            if (is == null) {
                throw new FileNotFoundException("Encrypted password file not located");
            }
            doc = DocumentUtil.getDocument(is);
        } else {
            doc = DocumentUtil.getDocument(docFile);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storePasswordEncryptedDocument(Document doc) throws Exception {
        byte[] data = DocumentUtil.getDocumentAsString(doc).getBytes();
        FileOutputStream faos = null;
        try {
            URL url = new URL(this.passwordEncryptedFileName);
            File file = new File(url.toString());
            faos = new FileOutputStream(file);
            faos.write(data);
            faos.flush();
            faos.close();
        }
        catch (Exception e) {
            if (faos == null) {
                faos = new FileOutputStream(new File(this.passwordEncryptedFileName));
            }
        }
        finally {
            if (faos == null) {
                throw new RuntimeException("File Output Stream is null");
            }
            faos.write(data);
            faos.flush();
            faos.close();
        }
    }
}

