/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.ssl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.naming.InitialContext;
import javax.net.ServerSocketFactory;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityDomain;
import org.jboss.security.ssl.DomainServerSocketFactory;
import org.jboss.security.ssl.JaasSecurityDomainServerSocketFactoryMBean;

public class JaasSecurityDomainServerSocketFactory
extends DomainServerSocketFactory
implements JaasSecurityDomainServerSocketFactoryMBean {
    private static Logger log = Logger.getLogger(JaasSecurityDomainServerSocketFactory.class);
    private String securityDomainName;

    public JaasSecurityDomainServerSocketFactory() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Creating socket factory: " + this.getClass().getName()));
        }
        SecurityDomain sd = this.getJaasSecurityDomain();
        this.setSecurityDomain(sd);
    }

    public static ServerSocketFactory getDefault() {
        JaasSecurityDomainServerSocketFactory jsdssf = new JaasSecurityDomainServerSocketFactory();
        return jsdssf;
    }

    protected SecurityDomain getJaasSecurityDomain() {
        final String name = this.getSystemPropertyName();
        String secDomain = null;
        secDomain = this.securityDomainName != null ? this.securityDomainName : (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return System.getProperty(name);
            }
        });
        if (secDomain != null) {
            if (!secDomain.startsWith("java:/jaas/") || !secDomain.startsWith("java:jaas/")) {
                secDomain = "java:/jaas/" + secDomain;
            }
            try {
                InitialContext iniCtx = new InitialContext();
                SecurityDomain sd = (SecurityDomain)iniCtx.lookup(secDomain);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Created Security Domain object from " + secDomain + ":" + sd.toString()));
                }
                return sd;
            }
            catch (Exception e) {
                log.error((Object)("Failed to create Security Domain '" + secDomain + "'"), (Throwable)e);
            }
        }
        return null;
    }

    protected String getSystemPropertyName() {
        return "org.jboss.security.ssl.server.domain.name";
    }

    public void create() throws Exception {
    }

    public void destroy() throws Exception {
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public String getSecurityDomainName() {
        return this.securityDomainName;
    }

    public void setSecurityDomainName(String securityDomainName) {
        this.securityDomainName = securityDomainName;
    }
}

