/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.linter;

import com.google.caja.lexer.CharProducer;

final class FileContent
implements CharSequence {
    private final CharProducer cp;
    private final int offset;
    private final int length;

    FileContent(CharProducer cp) {
        this(cp.clone(), cp.getOffset(), cp.getLength());
    }

    private FileContent(CharProducer cp, int offset, int length) {
        this.cp = cp;
        this.offset = offset;
        this.length = length;
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.cp.getBuffer()[index + this.offset];
    }

    public int length() {
        return this.length;
    }

    public CharSequence subSequence(int start, int end) {
        return new FileContent(this.cp, this.offset + start, end - start);
    }
}

