/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Hashtable;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.debug.ProtocolTester;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;

public class NakackTest
extends TestCase {
    static final long WAIT_TIME = 5000L;
    public static final long NUM_MSGS = 10000L;
    long num_msgs_received = 0L;
    long num_msgs_sent = 0L;

    public NakackTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.num_msgs_received = 0L;
        this.num_msgs_sent = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test0() throws Exception {
        Object mutex = new Object();
        CheckNoGaps check = new CheckNoGaps(1L, this, mutex);
        ProtocolTester t = new ProtocolTester("pbcast.NAKACK", check);
        IpAddress my_addr = new IpAddress("localhost", 10000);
        ViewId vid = new ViewId(my_addr, 322649L);
        Vector<Address> mbrs = new Vector<Address>();
        mbrs.addElement(my_addr);
        View view = new View(vid, mbrs);
        t.start();
        t.getBottom().up(new Event(8, my_addr));
        check.down(new Event(16));
        check.down(new Event(6, view));
        for (long i = 1L; i <= 10000L; ++i) {
            if (i % 1000L == 0L) {
                System.out.println("sending msg #" + i);
            }
            check.down(new Event(1, new Message(null, (Address)my_addr, new Long(i))));
            ++this.num_msgs_sent;
        }
        Object object = mutex;
        synchronized (object) {
            while (!check.isDone()) {
                mutex.wait(5000L);
            }
        }
        System.out.println("\nMessages sent: " + this.num_msgs_sent + ", messages received: " + this.num_msgs_received);
        NakackTest.assertEquals((long)this.num_msgs_received, (long)this.num_msgs_sent);
        t.stop();
    }

    public static Test suite() {
        return new TestSuite(NakackTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)NakackTest.suite());
    }

    private static class CheckNoGaps
    extends Protocol {
        long starting_seqno = 1L;
        Hashtable senders = new Hashtable();
        NakackTest t = null;
        final Object mut;
        long highest_seqno = this.starting_seqno;
        boolean done = false;

        CheckNoGaps(long seqno, NakackTest t, Object mut) {
            this.starting_seqno = seqno;
            this.t = t;
            this.mut = mut;
        }

        @Override
        public String getName() {
            return "CheckNoGaps";
        }

        public boolean isDone() {
            return this.done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object up(Event evt) {
            block13: {
                Message msg = null;
                if (evt == null) {
                    return null;
                }
                if (evt.getType() == 8) {
                    System.out.println("local address is " + evt.getArg());
                }
                if (evt.getType() != 1) {
                    return null;
                }
                msg = (Message)evt.getArg();
                Address sender = msg.getSrc();
                if (sender == null) {
                    this.log.error((Object)"NakackTest.CheckNoGaps.up(): sender is null; discarding msg");
                    return null;
                }
                Long s = (Long)this.senders.get(sender);
                if (s == null) {
                    s = new Long(this.starting_seqno);
                    this.senders.put(sender, s);
                }
                try {
                    s = (Long)msg.getObject();
                    long received_seqno = s;
                    if (received_seqno == this.highest_seqno) {
                        if (received_seqno % 1000L == 0L && received_seqno > 0L) {
                            System.out.println("PASS: received msg #" + received_seqno);
                        }
                        this.senders.put(sender, new Long(this.highest_seqno));
                        ++this.highest_seqno;
                        Object object = this.mut;
                        synchronized (object) {
                            ++this.t.num_msgs_received;
                            if (this.t.num_msgs_received >= 10000L) {
                                this.done = true;
                                this.mut.notifyAll();
                            }
                            break block13;
                        }
                    }
                    Assert.fail((String)("FAIL: received msg #" + received_seqno + ", expected " + this.highest_seqno));
                }
                catch (Exception ex) {
                    this.log.error((Object)"NakackTest.CheckNoGaps.up()", (Throwable)ex);
                }
            }
            return null;
        }
    }
}

