/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.usermodel.Range;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.exoplatform.services.document.impl.POIPropertiesReader;

public class MSWordDocumentReader
extends BaseDocumentReader {
    public String[] getMimeTypes() {
        return new String[]{"application/msword", "application/msworddoc", "application/msworddot"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentAsText(final InputStream is) throws IOException, DocumentReadException {
        if (is == null) {
            throw new NullPointerException("InputStream is null.");
        }
        String text = "";
        try {
            HWPFDocument doc;
            if (is.available() == 0) {
                String string = "";
                return string;
            }
            try {
                doc = (HWPFDocument)SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<HWPFDocument>(){

                    @Override
                    public HWPFDocument run() throws Exception {
                        return new HWPFDocument(is);
                    }
                });
            }
            catch (IOException e) {
                throw new DocumentReadException("Can't open document.", e);
            }
            Range range = doc.getRange();
            text = range.text();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return text.trim();
    }

    public String getContentAsText(InputStream is, String encoding) throws IOException, DocumentReadException {
        return this.getContentAsText(is);
    }

    public Properties getProperties(InputStream is) throws IOException, DocumentReadException {
        POIPropertiesReader reader = new POIPropertiesReader();
        reader.readDCProperties(is);
        return reader.getProperties();
    }
}

