/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.classmetamodel;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jboss.serial.classmetamodel.ClassMetaData;
import org.jboss.serial.classmetamodel.ClassMetaDataSlot;
import org.jboss.serial.classmetamodel.ClassMetadataField;
import org.jboss.serial.classmetamodel.ClassMetamodelFactory;
import org.jboss.serial.classmetamodel.ClassResolver;

public class StreamingClass {
    ClassMetaData metadata;
    private short[][] keyFields;

    public StreamingClass(Class clazz) throws IOException {
        this.metadata = ClassMetamodelFactory.getClassMetaData(clazz, false);
    }

    public StreamingClass(ClassMetaData clazz) throws IOException {
        this.metadata = clazz;
    }

    public static void saveStream(ClassMetaData metadata, ObjectOutput out) throws IOException {
        out.writeUTF(metadata.getClassName());
        ClassMetaDataSlot[] slots = metadata.getSlots();
        out.writeShort(slots.length);
        for (int slotNR = 0; slotNR < slots.length; ++slotNR) {
            out.writeLong(slots[slotNR].getShaHash());
            ClassMetadataField[] fields = slots[slotNR].getFields();
            out.writeShort(fields.length);
            for (int fieldNR = 0; fieldNR < fields.length; ++fieldNR) {
                out.writeLong(fields[fieldNR].getShaHash());
            }
        }
    }

    public static StreamingClass readStream(ObjectInput inp, ClassResolver resolver, ClassLoader loader) throws IOException {
        ClassMetaDataSlot[] slots;
        String className = inp.readUTF();
        ClassMetaData metadata = ClassMetamodelFactory.getClassMetaData(className, resolver, loader, false);
        StreamingClass streamClass = new StreamingClass(metadata);
        short slotsNrOnStreaming = inp.readShort();
        if (slotsNrOnStreaming != (slots = metadata.getSlots()).length) {
            throw new IOException("The hierarchy of " + className + " is different in your current classPath");
        }
        short[][] keyfields = new short[slots.length][];
        for (int slotIndex = 0; slotIndex < slots.length; ++slotIndex) {
            long shaSlotHash = inp.readLong();
            if (slots[slotIndex].getShaHash() != shaSlotHash) {
                throw new IOException("The hierarchy of " + className + " is different in your current classPath");
            }
            short numberofFields = inp.readShort();
            keyfields[slotIndex] = new short[numberofFields];
            ClassMetadataField[] fields = slots[slotIndex].getFields();
            if (numberofFields > fields.length) {
                throw new IOException("Current classpath has lesser fields on " + className + " than its original version");
            }
            for (int fieldIndex = 0; fieldIndex < fields.length; fieldIndex = (int)((short)(fieldIndex + 1))) {
                long hashfield = inp.readLong();
                ClassMetadataField fieldOnHash = slots[slotIndex].getField(hashfield);
                if (fieldOnHash == null) {
                    throw new IOException("Field hash " + fieldOnHash + " is not available on current classPath for class " + className);
                }
                keyfields[slotIndex][fieldIndex] = fieldOnHash.getOrder();
            }
        }
        streamClass.keyFields = keyfields;
        return streamClass;
    }

    public short[][] getKeyFields() {
        return this.keyFields;
    }

    public void setKeyFields(short[][] keyFields) {
        this.keyFields = keyFields;
    }

    public ClassMetaData getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ClassMetaData metadata) {
        this.metadata = metadata;
    }
}

