/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jbc2;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.Region;
import org.hibernate.cache.jbc2.util.CacheHelper;
import org.hibernate.cache.jbc2.util.NonLockingDataVersion;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.Option;
import org.jboss.cache.notifications.annotation.NodeInvalidated;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.ViewChanged;
import org.jboss.cache.notifications.event.NodeInvalidatedEvent;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.notifications.event.ViewChangedEvent;
import org.jboss.cache.optimistic.DataVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicRegionAdapter
implements Region {
    public static final String ITEM = "item";
    protected final Cache jbcCache;
    protected final String regionName;
    protected final Fqn regionFqn;
    protected final Fqn internalFqn;
    protected Node regionRoot;
    protected final boolean optimistic;
    protected final TransactionManager transactionManager;
    protected final Logger log;
    protected final Object regionRootMutex = new Object();
    protected final Object memberId;
    protected final boolean replication;
    protected final Object invalidationMutex = new Object();
    protected final AtomicReference<InvalidateState> invalidateState = new AtomicReference<InvalidateState>(InvalidateState.VALID);
    protected final Set<Object> currentView = new HashSet<Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicRegionAdapter(Cache jbcCache, String regionName, String regionPrefix) {
        this.log = LoggerFactory.getLogger(this.getClass());
        this.jbcCache = jbcCache;
        this.transactionManager = jbcCache.getConfiguration().getRuntimeConfig().getTransactionManager();
        this.regionName = regionName;
        this.regionFqn = this.createRegionFqn(regionName, regionPrefix);
        this.internalFqn = CacheHelper.getInternalFqn(this.regionFqn);
        this.optimistic = jbcCache.getConfiguration().getNodeLockingScheme() == Configuration.NodeLockingScheme.OPTIMISTIC;
        this.memberId = jbcCache.getLocalAddress();
        this.replication = CacheHelper.isClusteredReplication(jbcCache);
        this.jbcCache.addCacheListener((Object)this);
        Set<Object> set = this.currentView;
        synchronized (set) {
            List view = jbcCache.getMembers();
            if (view != null) {
                this.currentView.addAll(view);
            }
        }
        this.activateLocalClusterNode();
        this.log.debug("Created Region for " + regionName + " -- regionPrefix is " + regionPrefix);
    }

    protected abstract Fqn<String> createRegionFqn(String var1, String var2);

    protected void activateLocalClusterNode() {
        Transaction tx = this.suspend();
        try {
            Configuration cfg = this.jbcCache.getConfiguration();
            if (cfg.isUseRegionBasedMarshalling()) {
                org.jboss.cache.Region jbcRegion = this.jbcCache.getRegion(this.regionFqn, true);
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                jbcRegion.registerContextClassLoader(classLoader);
                if (!jbcRegion.isActive()) {
                    jbcRegion.activate();
                }
            }
            this.regionRoot = this.jbcCache.getRoot().getChild(this.regionFqn);
            if (this.regionRoot == null || !this.regionRoot.isValid()) {
                DataVersion version = this.optimistic ? NonLockingDataVersion.INSTANCE : null;
                this.regionRoot = CacheHelper.addNode(this.jbcCache, this.regionFqn, true, true, version);
            } else if (this.optimistic && this.regionRoot instanceof NodeSPI && !(((NodeSPI)this.regionRoot).getVersion() instanceof NonLockingDataVersion)) {
                ((NodeSPI)this.regionRoot).setVersion(NonLockingDataVersion.INSTANCE);
            }
            if (!this.regionRoot.isResident()) {
                this.regionRoot.setResident(true);
            }
            this.establishInternalNodes();
        }
        catch (Exception e) {
            throw new CacheException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.resume(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establishRegionRootNode() {
        Object object = this.regionRootMutex;
        synchronized (object) {
            if (this.regionRoot != null && this.regionRoot.isValid()) {
                return;
            }
            if (!this.optimistic) {
                this.establishInternalNodes();
                this.regionRoot = this.jbcCache.getRoot().getChild(this.regionFqn);
                return;
            }
            Transaction tx = this.suspend();
            Node newRoot = null;
            try {
                newRoot = this.jbcCache.getRoot().getChild(this.regionFqn);
                if (newRoot == null || !newRoot.isValid()) {
                    DataVersion version = this.optimistic ? NonLockingDataVersion.INSTANCE : null;
                    newRoot = CacheHelper.addNode(this.jbcCache, this.regionFqn, true, true, version);
                } else if (newRoot instanceof NodeSPI && !(((NodeSPI)newRoot).getVersion() instanceof NonLockingDataVersion)) {
                    ((NodeSPI)newRoot).setVersion(NonLockingDataVersion.INSTANCE);
                }
                newRoot.setResident(true);
                this.establishInternalNodes();
            }
            finally {
                this.resume(tx);
                this.regionRoot = newRoot;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establishInternalNodes() {
        Set<Object> set = this.currentView;
        synchronized (set) {
            Transaction tx = this.suspend();
            try {
                for (Object member : this.currentView) {
                    DataVersion version = this.optimistic ? NonLockingDataVersion.INSTANCE : null;
                    Fqn f = Fqn.fromRelativeElements((Fqn)this.internalFqn, (Object[])new Object[]{member});
                    CacheHelper.addNode(this.jbcCache, f, true, false, version);
                }
            }
            finally {
                this.resume(tx);
            }
        }
    }

    public String getName() {
        return this.regionName;
    }

    public Cache getCacheInstance() {
        return this.jbcCache;
    }

    public Fqn getRegionFqn() {
        return this.regionFqn;
    }

    public Object getMemberId() {
        return this.memberId;
    }

    public void ensureRegionRootExists() {
        if (this.regionRoot == null || !this.regionRoot.isValid()) {
            this.establishRegionRootNode();
        }
        if (this.regionRoot != null && this.regionRoot.isValid() && !this.regionRoot.isResident()) {
            this.regionRoot.setResident(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkValid() {
        boolean valid;
        boolean bl = valid = this.invalidateState.get() == InvalidateState.VALID;
        if (!valid) {
            Object object = this.invalidationMutex;
            synchronized (object) {
                if (this.invalidateState.compareAndSet(InvalidateState.INVALID, InvalidateState.CLEARING)) {
                    Transaction tx = this.suspend();
                    try {
                        Option opt = new Option();
                        opt.setLockAcquisitionTimeout(1);
                        opt.setCacheModeLocal(true);
                        CacheHelper.removeAll(this.jbcCache, this.regionFqn, opt);
                        this.invalidateState.compareAndSet(InvalidateState.CLEARING, InvalidateState.VALID);
                    }
                    catch (Exception e) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("Could not invalidate region: " + e.getLocalizedMessage());
                        }
                    }
                    finally {
                        this.resume(tx);
                    }
                }
            }
            valid = this.invalidateState.get() == InvalidateState.VALID;
        }
        return valid;
    }

    public void destroy() throws CacheException {
        try {
            Option option = new Option();
            option.setCacheModeLocal(true);
            option.setFailSilently(true);
            if (this.optimistic) {
                option.setDataVersion(NonLockingDataVersion.INSTANCE);
            }
            this.jbcCache.getInvocationContext().setOptionOverrides(option);
            this.jbcCache.removeNode(this.regionFqn);
            this.deactivateLocalNode();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
        finally {
            this.jbcCache.removeCacheListener((Object)this);
        }
    }

    protected void deactivateLocalNode() {
        org.jboss.cache.Region jbcRegion = this.jbcCache.getRegion(this.regionFqn, false);
        if (jbcRegion != null && jbcRegion.isActive()) {
            jbcRegion.deactivate();
            jbcRegion.unregisterContextClassLoader();
        }
    }

    public boolean contains(Object key) {
        if (!this.checkValid()) {
            return false;
        }
        try {
            Option opt = new Option();
            opt.setLockAcquisitionTimeout(100);
            CacheHelper.setInvocationOption(this.jbcCache, opt);
            return CacheHelper.getAllowingTimeout(this.jbcCache, this.regionFqn, key) != null;
        }
        catch (CacheException ce) {
            throw ce;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public long getElementCountInMemory() {
        if (this.checkValid()) {
            try {
                Set childrenNames = CacheHelper.getChildrenNames(this.jbcCache, this.regionFqn);
                int size = childrenNames.size();
                if (childrenNames.contains((Object)CacheHelper.Internal.NODE)) {
                    --size;
                }
                return size;
            }
            catch (CacheException ce) {
                throw ce;
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
        return 0L;
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public Map toMap() {
        if (this.checkValid()) {
            try {
                HashMap result = new HashMap();
                Set childrenNames = CacheHelper.getChildrenNames(this.jbcCache, this.regionFqn);
                for (Object childName : childrenNames) {
                    if (CacheHelper.Internal.NODE == childName) continue;
                    result.put(childName, CacheHelper.get(this.jbcCache, this.regionFqn, childName));
                }
                return result;
            }
            catch (CacheException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
        return Collections.emptyMap();
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public int getTimeout() {
        return 600;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object suspendAndGet(Object key, Option opt, boolean suppressTimeout) throws CacheException {
        Transaction tx = this.suspend();
        try {
            CacheHelper.setInvocationOption(this.getCacheInstance(), opt);
            if (suppressTimeout) {
                Object object = CacheHelper.getAllowingTimeout(this.getCacheInstance(), this.getRegionFqn(), key);
                return object;
            }
            Object object = CacheHelper.get(this.getCacheInstance(), this.getRegionFqn(), key);
            return object;
        }
        finally {
            this.resume(tx);
        }
    }

    public Transaction suspend() {
        Transaction tx = null;
        try {
            if (this.transactionManager != null) {
                tx = this.transactionManager.suspend();
            }
        }
        catch (SystemException se) {
            throw new CacheException("Could not suspend transaction", (Throwable)se);
        }
        return tx;
    }

    public void resume(Transaction tx) {
        try {
            if (tx != null) {
                this.transactionManager.resume(tx);
            }
        }
        catch (Exception e) {
            throw new CacheException("Could not resume transaction", (Throwable)e);
        }
    }

    protected Option getNonLockingDataVersionOption(boolean allowNullReturn) {
        return this.optimistic ? NonLockingDataVersion.getInvocationOption() : (allowNullReturn ? null : new Option());
    }

    public static Fqn<String> getTypeFirstRegionFqn(String regionName, String regionPrefix, String regionType) {
        Fqn base = Fqn.fromString((String)regionType);
        Fqn added = Fqn.fromString((String)BasicRegionAdapter.escapeRegionName(regionName, regionPrefix));
        return new Fqn(base, added);
    }

    public static Fqn<String> getTypeLastRegionFqn(String regionName, String regionPrefix, String regionType) {
        Fqn base = Fqn.fromString((String)BasicRegionAdapter.escapeRegionName(regionName, regionPrefix));
        return new Fqn(base, (Object[])new String[]{regionType});
    }

    public static String escapeRegionName(String regionName, String regionPrefix) {
        String escaped = null;
        int idx = -1;
        if (regionPrefix != null) {
            idx = regionName.indexOf(regionPrefix);
        }
        if (idx > -1) {
            int regionEnd = idx + regionPrefix.length();
            String prefix = regionName.substring(0, regionEnd);
            String suffix = regionName.substring(regionEnd);
            suffix = suffix.replace('.', '/');
            escaped = prefix + suffix;
        } else {
            escaped = regionName.replace('.', '/');
            if (regionPrefix != null && regionPrefix.length() > 0) {
                escaped = regionPrefix + "/" + escaped;
            }
        }
        return escaped;
    }

    @NodeModified
    public void nodeModified(NodeModifiedEvent event) {
        this.handleEvictAllModification(event);
    }

    protected boolean handleEvictAllModification(NodeModifiedEvent event) {
        if (!event.isPre() && (this.replication || event.isOriginLocal()) && event.getData().containsKey(ITEM) && event.getFqn().isChildOf(this.internalFqn)) {
            this.invalidateState.set(InvalidateState.INVALID);
            return true;
        }
        return false;
    }

    @NodeInvalidated
    public void nodeInvalidated(NodeInvalidatedEvent event) {
        this.handleEvictAllInvalidation(event);
    }

    protected boolean handleEvictAllInvalidation(NodeInvalidatedEvent event) {
        if (!event.isPre() && event.getFqn().isChildOf(this.internalFqn)) {
            this.invalidateState.set(InvalidateState.INVALID);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ViewChanged
    public void viewChanged(ViewChangedEvent event) {
        Set<Object> set = this.currentView;
        synchronized (set) {
            Vector view = event.getNewView().getMembers();
            if (view != null) {
                this.currentView.addAll(view);
                this.establishInternalNodes();
            }
        }
    }

    private static enum InvalidateState {
        INVALID,
        CLEARING,
        VALID;

    }
}

