/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.tomcat.util.http.TomcatCookie;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.PassivationConfig;
import org.jboss.web.tomcat.service.session.AbstractJBossManager;
import org.jboss.web.tomcat.service.session.ClusteredSession;
import org.jboss.web.tomcat.service.session.JBossManagerMBean;
import org.jboss.web.tomcat.service.session.SessionIDGenerator;
import org.jboss.web.tomcat.service.session.distributedcache.spi.ClusteringNotSupportedException;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingDistributableSessionData;
import org.jboss.web.tomcat.statistics.ReplicationStatistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JBossManager
implements AbstractJBossManager,
Lifecycle,
JBossManagerMBean,
PropertyChangeListener {
    protected ReplicationStatistics stats_ = new ReplicationStatistics();
    protected boolean passivationMode_ = false;
    protected long passivationMinIdleTime_ = -1L;
    protected long passivationMaxIdleTime_ = -1L;
    protected LifecycleSupport lifecycle_ = new LifecycleSupport((Lifecycle)this);
    protected boolean started_ = false;
    protected AtomicBoolean backgroundProcessAllowed = new AtomicBoolean();
    protected ObjectName objectName_;
    protected Logger log_ = Logger.getLogger((String)this.getClass().getName());
    protected boolean trace_ = this.log_.isTraceEnabled();
    protected Container container_;
    protected boolean distributable_ = true;
    protected int maxInactiveInterval_ = 60;
    protected int maxActiveAllowed_ = -1;
    protected AtomicInteger createdCounter_ = new AtomicInteger();
    protected AtomicInteger rejectedCounter_ = new AtomicInteger();
    protected AtomicInteger localActiveCounter_ = new AtomicInteger();
    protected AtomicInteger maxLocalActiveCounter_ = new AtomicInteger();
    protected AtomicInteger maxActiveCounter_ = new AtomicInteger();
    protected AtomicInteger expiredCounter_ = new AtomicInteger();
    protected long timeSinceLastReset_ = 0L;
    protected AtomicLong processingTime_ = new AtomicLong();
    protected final Map<String, ClusteredSession<? extends OutgoingDistributableSessionData>> sessions_ = new ConcurrentHashMap<String, ClusteredSession<? extends OutgoingDistributableSessionData>>();
    protected PropertyChangeSupport support_ = new PropertyChangeSupport(this);
    protected SessionIDGenerator sessionIDGenerator_ = SessionIDGenerator.getInstance();
    protected String jvmRoute_;
    protected MBeanServer mserver_ = null;
    protected volatile int processExpiresFrequency = 1;
    protected int backgroundProcessCount = 0;
    protected AtomicInteger maxAliveTime = new AtomicInteger();
    protected AtomicInteger averageAliveTime = new AtomicInteger();
    protected AtomicInteger duplicates_ = new AtomicInteger();

    protected JBossManager() {
    }

    public boolean getUseSessionPassivation() {
        return this.passivationMode_;
    }

    public void setUseSessionPassivation(boolean enabled) {
        this.passivationMode_ = enabled;
    }

    public long getPassivationMinIdleTime() {
        return this.passivationMinIdleTime_;
    }

    public void setPassivationMinIdleTime(long passivationMinIdleTime) {
        this.passivationMinIdleTime_ = passivationMinIdleTime;
    }

    public long getPassivationMaxIdleTime() {
        return this.passivationMaxIdleTime_;
    }

    public void setPassivationMaxIdleTime(long passivationMaxIdleTime) {
        this.passivationMaxIdleTime_ = passivationMaxIdleTime;
    }

    @Override
    public void init(String name, JBossWebMetaData webMetaData) throws ClusteringNotSupportedException {
        PassivationConfig pConfig;
        if (webMetaData.getMaxActiveSessions() != null) {
            this.maxActiveAllowed_ = webMetaData.getMaxActiveSessions();
        }
        if ((pConfig = webMetaData.getPassivationConfig()) != null && pConfig.getUseSessionPassivation() != null) {
            this.setUseSessionPassivation(pConfig.getUseSessionPassivation());
            if (this.getUseSessionPassivation()) {
                Integer max;
                Integer min = pConfig.getPassivationMinIdleTime();
                if (min != null) {
                    this.setPassivationMinIdleTime(min.intValue());
                }
                if ((max = pConfig.getPassivationMaxIdleTime()) != null) {
                    this.setPassivationMaxIdleTime(max.intValue());
                }
            }
        }
        this.log_.debug((Object)("init(): maxActiveSessions allowed is " + this.maxActiveAllowed_ + " and passivationMode is " + this.passivationMode_));
    }

    @Override
    public String getJvmRoute() {
        if (this.jvmRoute_ == null) {
            Engine e = this.getEngine();
            this.jvmRoute_ = e == null ? null : e.getJvmRoute();
        }
        return this.jvmRoute_;
    }

    @Override
    public void setNewSessionCookie(String sessionId, HttpServletResponse response) {
        if (response != null) {
            Context context = (Context)this.container_;
            Connector connector = ((Response)response).getConnector();
            if (context.getCookies()) {
                TomcatCookie cookie = new TomcatCookie(Globals.SESSION_COOKIE_NAME, sessionId);
                cookie.setMaxAge(-1);
                if (context.getSessionCookie().getPath() != null) {
                    cookie.setPath(context.getSessionCookie().getPath());
                } else {
                    String contextPath = context.getEncodedPath();
                    if ("".equals(contextPath)) {
                        contextPath = "/";
                    }
                    cookie.setPath(contextPath);
                }
                if (context.getSessionCookie().getComment() != null) {
                    cookie.setComment(context.getSessionCookie().getComment());
                }
                if (context.getSessionCookie().getDomain() != null) {
                    cookie.setDomain(context.getSessionCookie().getDomain());
                }
                if (context.getSessionCookie().isHttpOnly()) {
                    cookie.setHttpOnly(true);
                }
                if (context.getSessionCookie().isSecure()) {
                    cookie.setSecure(true);
                }
                if (connector.getSecure()) {
                    cookie.setSecure(true);
                }
                if (this.trace_) {
                    this.log_.trace((Object)("Setting cookie with session id:" + sessionId + " & name:" + Globals.SESSION_COOKIE_NAME));
                }
                response.addCookie((Cookie)cookie);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support_.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support_.removePropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.support_.firePropertyChange(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backgroundProcess() {
        this.trace_ = this.log_.isTraceEnabled();
        this.backgroundProcessCount = (this.backgroundProcessCount + 1) % this.processExpiresFrequency;
        if (this.backgroundProcessCount != 0) {
            return;
        }
        AtomicBoolean atomicBoolean = this.backgroundProcessAllowed;
        synchronized (atomicBoolean) {
            if (this.backgroundProcessAllowed.get()) {
                long start = System.currentTimeMillis();
                this.processExpirationPassivation();
                long elapsed = System.currentTimeMillis() - start;
                this.processingTime_.addAndGet(elapsed);
            }
        }
    }

    @Override
    public int getActiveSessions() {
        return (int)this.getLocalActiveSessionCount();
    }

    public Container getContainer() {
        return this.container_;
    }

    public void setContainer(Container container) {
        if (this.container_ != null && this.container_ instanceof Context) {
            this.container_.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.container_ = container;
        if (this.container_ != null && this.container_ instanceof Context) {
            this.setMaxInactiveInterval(((Context)this.container_).getSessionTimeout() * 60);
            this.container_.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public boolean getDistributable() {
        return this.distributable_;
    }

    public void setDistributable(boolean distributable) {
        this.distributable_ = distributable;
    }

    @Override
    public int getExpiredSessions() {
        return this.expiredCounter_.get();
    }

    public void setExpiredSessions(int expiredSessions) {
    }

    @Override
    public int getMaxActive() {
        return this.maxActiveAllowed_;
    }

    public void setMaxActive(int maxActive) {
        this.maxActiveAllowed_ = maxActive;
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval_;
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval_ = interval;
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime_.get();
    }

    @Override
    public int getRejectedSessions() {
        return this.rejectedCounter_.get();
    }

    public void setRejectedSessions(int rejectedSessions) {
    }

    @Override
    public int getSessionAverageAliveTime() {
        return this.averageAliveTime.get();
    }

    public void setSessionAverageAliveTime(int sessionAverageAliveTime) {
    }

    @Override
    public int getSessionCounter() {
        return this.createdCounter_.get();
    }

    public void setSessionCounter(int sessionCounter) {
    }

    @Override
    public int getSessionIdLength() {
        return 16;
    }

    public void setSessionIdLength(int idLength) {
    }

    @Override
    public int getSessionMaxAliveTime() {
        return this.maxAliveTime.get();
    }

    public void setSessionMaxAliveTime(int sessionAliveTime) {
    }

    public void load() throws ClassNotFoundException, IOException {
        throw new UnsupportedOperationException("load() not supported");
    }

    public void unload() throws IOException {
        throw new UnsupportedOperationException("unload() not supported");
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle_.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle_.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle_.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        this.startManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws LifecycleException {
        AtomicBoolean atomicBoolean = this.backgroundProcessAllowed;
        synchronized (atomicBoolean) {
            this.backgroundProcessAllowed.set(false);
        }
        this.resetStats();
        this.stopManager();
    }

    @Override
    public long getActiveSessionCount() {
        return this.calcActiveSessions();
    }

    @Override
    public String getAlgorithm() {
        return "MD5";
    }

    @Override
    public String getClassName() {
        return this.getClass().getName();
    }

    @Override
    public long getCreatedSessionCount() {
        return this.createdCounter_.get();
    }

    @Override
    public long getExpiredSessionCount() {
        return this.expiredCounter_.get();
    }

    @Override
    public long getLocalActiveSessionCount() {
        return this.localActiveCounter_.get();
    }

    @Override
    public int getMaxActiveAllowed() {
        return this.getMaxActive();
    }

    @Override
    public void setMaxActiveAllowed(int maxActive) {
        this.setMaxActive(maxActive);
    }

    @Override
    public int getMaxActiveSessions() {
        return this.getMaxActiveAllowed();
    }

    @Override
    public long getMaxActiveSessionCount() {
        return this.maxActiveCounter_.get();
    }

    @Override
    public long getMaxLocalActiveSessionCount() {
        return this.maxLocalActiveCounter_.get();
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public int getProcessExpiresFrequency() {
        return this.processExpiresFrequency;
    }

    @Override
    public void setProcessExpiresFrequency(int frequency) {
        this.processExpiresFrequency = frequency;
    }

    @Override
    public long getRejectedSessionCount() {
        return this.rejectedCounter_.get();
    }

    @Override
    public ReplicationStatistics getReplicationStatistics() {
        return this.stats_;
    }

    @Override
    public long getTimeSinceLastReset() {
        return (System.currentTimeMillis() - this.timeSinceLastReset_) / 1000L;
    }

    @Override
    public String reportReplicationStatistics() {
        StringBuffer tmp = new StringBuffer();
        tmp.append("<table><tr>");
        tmp.append("<th>sessionID</th>");
        tmp.append("<th>replicationCount</th>");
        tmp.append("<th>minPassivationTime</th>");
        tmp.append("<th>maxPassivationTime</th>");
        tmp.append("<th>totalPassivationTime</th>");
        tmp.append("<th>minReplicationTime</th>");
        tmp.append("<th>maxReplicationTime</th>");
        tmp.append("<th>totalReplicationlTime</th>");
        tmp.append("<th>loadCount</th>");
        tmp.append("<th>minLoadTime</th>");
        tmp.append("<th>maxLoadTime</th>");
        tmp.append("<th>totalLoadTime</th>");
        HashMap<String, ReplicationStatistics.TimeStatistic> copy = new HashMap<String, ReplicationStatistics.TimeStatistic>(this.stats_.getStats());
        for (Map.Entry entry : copy.entrySet()) {
            ReplicationStatistics.TimeStatistic stat = (ReplicationStatistics.TimeStatistic)entry.getValue();
            if (stat == null) continue;
            tmp.append("<tr><td>");
            tmp.append((String)entry.getKey());
            tmp.append("</td><td>");
            tmp.append(stat.replicationCount);
            tmp.append("</td><td>");
            tmp.append(stat.minPassivationTime);
            tmp.append("</td><td>");
            tmp.append(stat.maxPassivationTime);
            tmp.append("</td><td>");
            tmp.append(stat.totalPassivationTime);
            tmp.append("</td><td>");
            tmp.append(stat.minReplicationTime);
            tmp.append("</td><td>");
            tmp.append(stat.maxReplicationTime);
            tmp.append("</td><td>");
            tmp.append(stat.totalReplicationlTime);
            tmp.append("</td><td>");
            tmp.append(stat.loadCount);
            tmp.append("</td><td>");
            tmp.append(stat.minLoadTime);
            tmp.append("</td><td>");
            tmp.append(stat.maxLoadTime);
            tmp.append("</td><td>");
            tmp.append(stat.totalLoadlTime);
            tmp.append("</td></tr>");
        }
        tmp.append("</table>");
        copy.clear();
        return tmp.toString();
    }

    @Override
    public String reportReplicationStatisticsCSV() {
        StringBuffer tmp = this.createCSVHeader();
        HashMap<String, ReplicationStatistics.TimeStatistic> copy = new HashMap<String, ReplicationStatistics.TimeStatistic>(this.stats_.getStats());
        for (Map.Entry entry : copy.entrySet()) {
            ReplicationStatistics.TimeStatistic stat = (ReplicationStatistics.TimeStatistic)entry.getValue();
            if (stat == null) continue;
            tmp.append("\n");
            tmp.append((String)entry.getKey());
            tmp.append(",");
            tmp.append(stat.replicationCount);
            tmp.append(",");
            tmp.append(stat.minPassivationTime);
            tmp.append(",");
            tmp.append(stat.maxPassivationTime);
            tmp.append(",");
            tmp.append(stat.totalPassivationTime);
            tmp.append(",");
            tmp.append(stat.minReplicationTime);
            tmp.append(",");
            tmp.append(stat.maxReplicationTime);
            tmp.append(",");
            tmp.append(stat.totalReplicationlTime);
            tmp.append(",");
            tmp.append(stat.loadCount);
            tmp.append(",");
            tmp.append(stat.minLoadTime);
            tmp.append(",");
            tmp.append(stat.maxLoadTime);
            tmp.append(",");
            tmp.append(stat.totalLoadlTime);
        }
        copy.clear();
        return tmp.toString();
    }

    @Override
    public String reportReplicationStatisticsCSV(String sessionId) {
        StringBuffer tmp = this.createCSVHeader();
        Map<String, ReplicationStatistics.TimeStatistic> stats = this.stats_.getStats();
        ReplicationStatistics.TimeStatistic stat = stats.get(sessionId);
        if (stat != null) {
            tmp.append("\n");
            tmp.append(sessionId);
            tmp.append(",");
            tmp.append(stat.replicationCount);
            tmp.append(",");
            tmp.append(stat.minPassivationTime);
            tmp.append(",");
            tmp.append(stat.maxPassivationTime);
            tmp.append(",");
            tmp.append(stat.totalPassivationTime);
            tmp.append(",");
            tmp.append(stat.minReplicationTime);
            tmp.append(",");
            tmp.append(stat.maxReplicationTime);
            tmp.append(",");
            tmp.append(stat.totalReplicationlTime);
            tmp.append(",");
            tmp.append(stat.loadCount);
            tmp.append(",");
            tmp.append(stat.minLoadTime);
            tmp.append(",");
            tmp.append(stat.maxLoadTime);
            tmp.append(",");
            tmp.append(stat.totalLoadlTime);
        }
        return tmp.toString();
    }

    @Override
    public void resetStats() {
        this.stats_.resetStats();
        this.maxActiveCounter_.set(this.localActiveCounter_.get());
        this.rejectedCounter_.set(0);
        this.createdCounter_.set(0);
        this.expiredCounter_.set(0);
        this.processingTime_.set(0L);
        this.maxAliveTime.set(0);
        this.averageAliveTime.set(0);
        this.duplicates_.set(0);
        this.timeSinceLastReset_ = System.currentTimeMillis();
    }

    public ObjectName getObjectName() {
        return this.objectName_;
    }

    protected abstract void processExpirationPassivation();

    protected abstract int getTotalActiveSessions();

    protected int calcActiveSessions() {
        this.localActiveCounter_.set(this.sessions_.size());
        int active = this.localActiveCounter_.get();
        int maxLocal = this.maxLocalActiveCounter_.get();
        while (active > maxLocal) {
            if (this.maxLocalActiveCounter_.compareAndSet(maxLocal, active)) continue;
            maxLocal = this.maxLocalActiveCounter_.get();
        }
        int count = this.getTotalActiveSessions();
        int max = this.maxActiveCounter_.get();
        while (count > max) {
            if (this.maxActiveCounter_.compareAndSet(max, count)) continue;
            max = this.maxActiveCounter_.get();
            count = this.getTotalActiveSessions();
        }
        return count;
    }

    protected ClusteredSession<? extends OutgoingDistributableSessionData> findLocalSession(String realId) {
        return this.sessions_.get(realId);
    }

    protected ClusteredSession<? extends OutgoingDistributableSessionData>[] findLocalSessions() {
        Collection<ClusteredSession<? extends OutgoingDistributableSessionData>> coll = this.sessions_.values();
        ClusteredSession[] sess = new ClusteredSession[coll.size()];
        return coll.toArray(sess);
    }

    protected String getNextId() {
        return this.sessionIDGenerator_.getSessionId();
    }

    protected void sessionExpired(int sessionAliveTime) {
        int expCount;
        int newAverage;
        int current = this.maxAliveTime.get();
        while (sessionAliveTime > current && !this.maxAliveTime.compareAndSet(current, sessionAliveTime)) {
            current = this.maxAliveTime.get();
        }
        this.expiredCounter_.incrementAndGet();
        do {
            expCount = this.expiredCounter_.get();
        } while (!this.averageAliveTime.compareAndSet(current = this.averageAliveTime.get(), newAverage = (current * (expCount - 1) + sessionAliveTime) / expCount));
    }

    protected void registerManagerMBean() {
        try {
            MBeanServer server = this.getMBeanServer();
            String domain = this.container_ instanceof ContainerBase ? ((ContainerBase)this.container_).getDomain() : server.getDefaultDomain();
            String hostName = ((Host)this.container_.getParent()).getName();
            hostName = hostName == null ? "localhost" : hostName;
            String path = ((Context)this.container_).getPath();
            path = "".equals(path) ? "/" : path;
            ObjectName clusterName = new ObjectName(domain + ":type=Manager,host=" + hostName + ",path=" + path);
            if (server.isRegistered(clusterName)) {
                this.log_.warn((Object)("MBean " + clusterName + " already registered"));
                return;
            }
            this.objectName_ = clusterName;
            server.registerMBean(this, clusterName);
        }
        catch (Exception ex) {
            this.log_.error((Object)("Could not register " + this.getClass().getSimpleName() + " to MBeanServer"), (Throwable)ex);
        }
    }

    protected void unregisterManagerMBean() {
        if (this.mserver_ != null && this.objectName_ != null) {
            try {
                this.mserver_.unregisterMBean(this.objectName_);
            }
            catch (Exception e) {
                this.log_.error((Object)("Could not unregister " + this.getClass().getSimpleName() + " from MBeanServer"), (Throwable)e);
            }
        }
    }

    protected MBeanServer getMBeanServer() throws Exception {
        if (this.mserver_ == null) {
            this.mserver_ = Registry.getRegistry(null, null).getMBeanServer();
        }
        return this.mserver_;
    }

    protected void startManager() throws LifecycleException {
        this.log_.debug((Object)"Starting JBossManager");
        if (this.started_) {
            throw new LifecycleException("JBossManager alreadyStarted");
        }
        this.backgroundProcessAllowed.set(true);
        this.lifecycle_.fireLifecycleEvent("start", null);
        this.started_ = true;
        this.registerManagerMBean();
    }

    protected void stopManager() throws LifecycleException {
        this.log_.debug((Object)"Stopping JBossManager");
        if (!this.started_) {
            throw new LifecycleException("JBossManager notStarted");
        }
        this.lifecycle_.fireLifecycleEvent("stop", null);
        this.started_ = false;
        this.unregisterManagerMBean();
    }

    private StringBuffer createCSVHeader() {
        StringBuffer tmp = new StringBuffer();
        tmp.append("sessionID,");
        tmp.append("replicationCount,");
        tmp.append("minPassivationTime,");
        tmp.append("maxPassivationTime,");
        tmp.append("totalPassivationTime,");
        tmp.append("minReplicationTime,");
        tmp.append("maxReplicationTime,");
        tmp.append("totalReplicationlTime,");
        tmp.append("loadCount,");
        tmp.append("minLoadTime,");
        tmp.append("maxLoadTime,");
        tmp.append("totalLoadTime");
        return tmp;
    }

    private Engine getEngine() {
        Engine e = null;
        for (Container c = this.getContainer(); e == null && c != null; c = c.getParent()) {
            if (c == null || !(c instanceof Engine)) continue;
            e = (Engine)c;
        }
        return e;
    }
}

