/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.util.Collection;
import java.util.Map;
import org.jboss.aop.Advised;
import org.jboss.web.tomcat.service.session.ClusteredManager;
import org.jboss.web.tomcat.service.session.ClusteredSession;
import org.jboss.web.tomcat.service.session.OutgoingDistributableSessionDataImpl;
import org.jboss.web.tomcat.service.session.Util;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributableSessionMetadata;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingDistributableSessionData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FieldBasedClusteredSession
extends ClusteredSession<OutgoingDistributableSessionData> {
    private static final long serialVersionUID = 8347544395334247623L;
    protected static final String info = "FieldBasedClusteredSession/1.0";

    public FieldBasedClusteredSession(ClusteredManager<OutgoingDistributableSessionData> manager) {
        super(manager);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    protected OutgoingDistributableSessionData getOutgoingSessionData() {
        boolean needFull = this.isFullReplicationNeeded();
        DistributableSessionMetadata metadata = needFull || this.isSessionMetadataDirty() ? this.getSessionMetadata() : null;
        Long timestamp = metadata != null || this.isSessionAttributeMapDirty() || this.getMustReplicateTimestamp() ? Long.valueOf(this.getSessionTimestamp()) : null;
        return new OutgoingDistributableSessionDataImpl(this.getRealId(), this.getVersion(), timestamp, metadata);
    }

    @Override
    protected boolean isMutable(Object attribute) {
        boolean pojo = attribute instanceof Advised;
        boolean mutable = !pojo && super.isMutable(attribute);
        return mutable;
    }

    @Override
    protected Object removeAttributeInternal(String name, boolean localCall, boolean localOnly) {
        if (localCall && !replicationExcludes.contains(name)) {
            if (localOnly) {
                this.getDistributedCacheManager().removeAttributeLocal(this.getRealId(), name);
            } else {
                this.getDistributedCacheManager().removeAttribute(this.getRealId(), name);
            }
            this.sessionAttributesDirty();
        }
        return this.getAttributesInternal().remove(name);
    }

    @Override
    protected boolean canAttributeBeReplicated(Object attribute) {
        return attribute == null || Util.checkPojoType(attribute);
    }

    @Override
    protected Object setAttributeInternal(String key, Object value) {
        if (!replicationExcludes.contains(key)) {
            String myRealId = this.getRealId();
            this.getDistributedCacheManager().putAttribute(myRealId, key, value);
            if (value instanceof Map || value instanceof Collection) {
                value = this.getDistributedCacheManager().getAttribute(myRealId, key);
            }
            this.sessionAttributesDirty();
        }
        return this.getAttributesInternal().put(key, value);
    }
}

