/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jbossas5.connection.LocalProfileServiceConnectionProvider;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.rhq.plugins.jbossas5.helper.JBossInstallationInfo;
import org.rhq.plugins.jbossas5.helper.JBossProductType;
import org.rhq.plugins.jbossas5.util.ManagedComponentUtils;

public class InProcessJBossASDiscovery {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String JAVA_HOME_ENV_VAR = "JAVA_HOME";

    public DiscoveredResourceDetails discoverInProcessJBossAS(ResourceDiscoveryContext discoveryContext) {
        JBossInstallationInfo installInfo;
        String serverHomeDir;
        ProfileServiceConnection connection;
        LocalProfileServiceConnectionProvider connectionProvider = new LocalProfileServiceConnectionProvider();
        try {
            connection = connectionProvider.connect();
        }
        catch (Exception e) {
            this.log.debug((Object)"Unable to connect to in-process ProfileService.", (Throwable)e);
            return null;
        }
        ManagementView managementView = connection.getManagementView();
        ManagedComponent serverConfigComponent = ManagedComponentUtils.getSingletonManagedComponent(managementView, new ComponentType("MCBean", "ServerConfig"));
        String serverName = (String)((Object)ManagedComponentUtils.getSimplePropertyValue(serverConfigComponent, "serverName"));
        String resourceKey = serverHomeDir = (String)((Object)ManagedComponentUtils.getSimplePropertyValue(serverConfigComponent, "serverHomeDir"));
        String homeDir = (String)((Object)ManagedComponentUtils.getSimplePropertyValue(serverConfigComponent, "homeDir"));
        try {
            installInfo = new JBossInstallationInfo(new File(homeDir));
        }
        catch (IOException e) {
            throw new InvalidPluginConfigurationException((Throwable)e);
        }
        JBossProductType productType = installInfo.getProductType();
        String resourceName = productType.NAME;
        resourceName = resourceName + " " + installInfo.getMajorVersion();
        resourceName = resourceName + " (" + serverName + ")";
        String description = productType.DESCRIPTION;
        String version = (String)((Object)ManagedComponentUtils.getSimplePropertyValue(serverConfigComponent, "specificationVersion"));
        String javaHome = System.getenv(JAVA_HOME_ENV_VAR);
        Configuration pluginConfig = discoveryContext.getDefaultPluginConfiguration();
        pluginConfig.put((Property)new PropertySimple("homeDir", (Object)homeDir));
        pluginConfig.put((Property)new PropertySimple("serverHomeDir", (Object)serverHomeDir));
        pluginConfig.put((Property)new PropertySimple("serverName", (Object)serverName));
        pluginConfig.put((Property)new PropertySimple("javaHome", (Object)javaHome));
        return new DiscoveredResourceDetails(discoveryContext.getResourceType(), resourceKey, resourceName, version, description, pluginConfig, null);
    }
}

