/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.async;

import java.io.Serializable;
import org.jboss.seam.bpm.BusinessProcess;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Init;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Work;

public abstract class Asynchronous
implements Serializable {
    static final long serialVersionUID = -551286304424595765L;
    private static final transient LogProvider log = Logging.getLogProvider(Asynchronous.class);
    private Long processId;
    private Long taskId;

    public Asynchronous() {
        if (Init.instance().isJbpmInstalled()) {
            BusinessProcess businessProcess = BusinessProcess.instance();
            this.processId = businessProcess.getProcessId();
            this.taskId = BusinessProcess.instance().getTaskId();
        }
    }

    public abstract void execute(Object var1);

    protected abstract void handleException(Exception var1, Object var2);

    protected abstract class ContextualAsynchronousRequest {
        private Object timer;
        private boolean createContexts;

        public ContextualAsynchronousRequest(Object timer) {
            this.timer = timer;
            this.createContexts = !Contexts.isEventContextActive() && !Contexts.isApplicationContextActive();
        }

        private void setup() {
            if (this.createContexts) {
                Lifecycle.beginCall();
            }
            Contexts.getEventContext().set("org.jboss.seam.core.executingAsynchronousCall", true);
            if (Asynchronous.this.taskId != null) {
                try {
                    new Work<Object>(){

                        @Override
                        protected Object work() throws Exception {
                            BusinessProcess.instance().resumeTask(Asynchronous.this.taskId);
                            return null;
                        }
                    }.workInTransaction();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else if (Asynchronous.this.processId != null) {
                BusinessProcess.instance().resumeProcess(Asynchronous.this.processId);
            }
            if (this.timer != null) {
                Contexts.getEventContext().set("timer", this.timer);
            }
            log.debug("executing: " + this);
        }

        protected abstract void process();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.setup();
            try {
                this.process();
            }
            finally {
                this.cleanup();
            }
        }

        private void cleanup() {
            Contexts.getEventContext().remove("org.jboss.seam.core.executingAsynchronousCall");
            if (this.createContexts) {
                Lifecycle.endCall();
            }
        }
    }
}

