/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client;

import java.util.ArrayList;
import java.util.List;
import org.jboss.jms.client.FailoverEvent;
import org.jboss.jms.client.FailoverListener;
import org.jboss.jms.client.FailoverValve2;
import org.jboss.jms.client.FailureDetector;
import org.jboss.jms.client.delegate.ClientConnectionDelegate;
import org.jboss.jms.client.remoting.JMSRemotingConnection;
import org.jboss.jms.client.state.ConnectionState;
import org.jboss.jms.delegate.ConnectionFactoryDelegate;
import org.jboss.jms.delegate.CreateConnectionResult;
import org.jboss.logging.Logger;

public class FailoverCommandCenter {
    private static final Logger log = Logger.getLogger(FailoverCommandCenter.class);
    private static boolean trace = log.isTraceEnabled();
    private ConnectionState state;
    private FailoverValve2 valve;
    private List failoverListeners;

    public FailoverCommandCenter(ConnectionState state) {
        this.state = state;
        this.failoverListeners = new ArrayList();
        this.valve = new FailoverValve2();
    }

    public void setState(ConnectionState state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean failureDetected(Throwable reason, FailureDetector source, JMSRemotingConnection remotingConnection) throws Exception {
        boolean bl;
        int failoverEvent;
        boolean valveOpened;
        boolean failoverSuccessful;
        block20: {
            boolean bl2;
            block18: {
                block19: {
                    log.debug((Object)("failure detected by " + source), reason);
                    this.broadcastFailoverEvent(new FailoverEvent(10, source));
                    CreateConnectionResult res = null;
                    failoverSuccessful = false;
                    valveOpened = false;
                    failoverEvent = 30;
                    try {
                        try {
                            this.valve.close();
                            FailoverCommandCenter failoverCommandCenter = this;
                            synchronized (failoverCommandCenter) {
                                if (remotingConnection.isFailed()) {
                                    log.debug((Object)(this + " ignoring failure detection notification, as failover was " + "already (or is in process of being) performed on this connection"));
                                    failoverSuccessful = true;
                                    failoverEvent = 40;
                                    bl2 = true;
                                    // MONITOREXIT @DISABLED, blocks:[0, 1, 17, 4] lbl17 : MonitorExitStatement: MONITOREXIT : var8_8
                                    Object var12_13 = null;
                                    if (valveOpened) break block18;
                                    break block19;
                                }
                                remotingConnection.setFailed();
                            }
                            log.info((Object)"JBoss Messaging server failure detected - waiting for failover to complete...");
                            this.broadcastFailoverEvent(new FailoverEvent(20, this));
                            int failedNodeID = this.state.getServerID();
                            ConnectionFactoryDelegate clusteredDelegate = this.state.getClusteredConnectionFactoryDelegate();
                            log.trace((Object)"Creating new connection");
                            res = clusteredDelegate.createConnectionDelegate(this.state.getUsername(), this.state.getPassword(), failedNodeID);
                            log.trace((Object)"Created connection");
                            if (res == null) {
                                failoverSuccessful = false;
                                log.trace((Object)"No failover");
                            } else {
                                ClientConnectionDelegate newDelegate = res.getDelegate();
                                log.trace((Object)"Synchronizing state");
                                this.state.getDelegate().synchronizeWith(newDelegate);
                                log.trace((Object)"Synchronized state");
                                if (this.state.isStarted()) {
                                    log.trace((Object)"Starting new connection");
                                    newDelegate.startAfterFailover();
                                    log.trace((Object)"Started new connection");
                                }
                                if (remotingConnection.getConnectionListener() != null && remotingConnection.getConnectionListener().getJMSExceptionListener() != null) {
                                    log.trace((Object)"Adding Exception Listener to new connection");
                                    newDelegate.setExceptionListener(remotingConnection.getConnectionListener().getJMSExceptionListener());
                                }
                                log.trace((Object)"Opening valve");
                                this.valve.open();
                                log.trace((Object)"Opened valve");
                                valveOpened = true;
                                failoverSuccessful = true;
                                log.info((Object)"JBoss Messaging failover complete");
                            }
                            log.trace((Object)"failureDetected() complete");
                            bl = failoverSuccessful;
                            break block20;
                        }
                        catch (Exception e) {
                            log.error((Object)"Failover failed", (Throwable)e);
                            throw e;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_15 = null;
                        if (!valveOpened) {
                            log.trace((Object)"finally opening valve");
                            this.valve.open();
                            log.trace((Object)"valve opened");
                        }
                        if (failoverSuccessful) {
                            log.debug((Object)(this + " completed successful failover"));
                            this.broadcastFailoverEvent(new FailoverEvent(failoverEvent, this));
                            throw throwable;
                        }
                        log.debug((Object)(this + " aborted failover"));
                        this.state.beforeAborting();
                        ClientConnectionDelegate connDelegate = (ClientConnectionDelegate)this.state.getDelegate();
                        connDelegate.closing(-1L);
                        connDelegate.close();
                        this.broadcastFailoverEvent(new FailoverEvent(100, this));
                        throw throwable;
                    }
                }
                log.trace((Object)"finally opening valve");
                this.valve.open();
                log.trace((Object)"valve opened");
            }
            if (failoverSuccessful) {
                log.debug((Object)(this + " completed successful failover"));
                this.broadcastFailoverEvent(new FailoverEvent(failoverEvent, this));
                return bl2;
            }
            log.debug((Object)(this + " aborted failover"));
            this.state.beforeAborting();
            ClientConnectionDelegate connDelegate = (ClientConnectionDelegate)this.state.getDelegate();
            connDelegate.closing(-1L);
            connDelegate.close();
            this.broadcastFailoverEvent(new FailoverEvent(100, this));
            return bl2;
        }
        Object var12_14 = null;
        if (!valveOpened) {
            log.trace((Object)"finally opening valve");
            this.valve.open();
            log.trace((Object)"valve opened");
        }
        if (failoverSuccessful) {
            log.debug((Object)(this + " completed successful failover"));
            this.broadcastFailoverEvent(new FailoverEvent(failoverEvent, this));
            return bl;
        }
        log.debug((Object)(this + " aborted failover"));
        this.state.beforeAborting();
        ClientConnectionDelegate connDelegate = (ClientConnectionDelegate)this.state.getDelegate();
        connDelegate.closing(-1L);
        connDelegate.close();
        this.broadcastFailoverEvent(new FailoverEvent(100, this));
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFailoverListener(FailoverListener listener) {
        List list = this.failoverListeners;
        synchronized (list) {
            this.failoverListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterFailoverListener(FailoverListener listener) {
        List list = this.failoverListeners;
        synchronized (list) {
            return this.failoverListeners.remove(listener);
        }
    }

    public FailoverValve2 getValve() {
        return this.valve;
    }

    public JMSRemotingConnection getRemotingConnection() {
        return this.state.getRemotingConnection();
    }

    public String toString() {
        return "FailoverCommandCenter[" + this.state + "]";
    }

    ConnectionState getConnectionState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastFailoverEvent(FailoverEvent e) {
        ArrayList listenersCopy;
        if (trace) {
            log.trace((Object)(this + " broadcasting " + e));
        }
        List list = this.failoverListeners;
        synchronized (list) {
            listenersCopy = new ArrayList(this.failoverListeners);
        }
        for (FailoverListener listener : listenersCopy) {
            try {
                listener.failoverEventOccured(e);
            }
            catch (Exception ex) {
                log.warn((Object)("Failover listener " + listener + " did not accept event"), (Throwable)ex);
            }
        }
    }
}

