/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.structure.modified;

import org.jboss.deployers.vfs.spi.structure.modified.StructureCache;
import org.jboss.deployers.vfs.spi.structure.modified.SynchAdapter;
import org.jboss.deployers.vfs.spi.structure.modified.SynchVisitor;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VisitorAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddVisitor
extends SynchVisitor {
    private VirtualFile tempRoot;
    private int initialPathLenght;

    public AddVisitor(VisitorAttributes attributes, StructureCache<Long> cache, SynchAdapter synchAdapter, VirtualFile tempRoot, int initialPathLenght) {
        this(null, attributes, cache, synchAdapter, tempRoot, initialPathLenght);
    }

    public AddVisitor(VirtualFileFilter filter, VisitorAttributes attributes, StructureCache<Long> cache, SynchAdapter synchAdapter, VirtualFile tempRoot, int initialPathLenght) {
        super(filter, attributes, cache, synchAdapter);
        if (tempRoot == null) {
            throw new IllegalArgumentException("Null temp root");
        }
        if (initialPathLenght < 0) {
            throw new IllegalArgumentException("Initial path length is negative: " + initialPathLenght);
        }
        this.tempRoot = tempRoot;
        this.initialPathLenght = initialPathLenght;
    }

    @Override
    public void doVisit(VirtualFile file) throws Exception {
        String originalPathName = file.getPathName();
        String pathName = originalPathName.substring(this.initialPathLenght);
        VirtualFile child = this.tempRoot.getChild(pathName);
        if (child == null) {
            long timestamp = this.getSynchAdapter().add(file, this.tempRoot, pathName);
            this.getCache().putCacheValue(originalPathName, timestamp);
        }
    }
}

