/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.iiop.rmi;

import java.lang.reflect.Method;
import java.rmi.Remote;
import org.jboss.iiop.rmi.AbstractAnalysis;
import org.jboss.iiop.rmi.OperationAnalysis;
import org.jboss.iiop.rmi.RMIIIOPViolationException;
import org.jboss.iiop.rmi.Util;
import org.omg.CORBA.AttributeMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeAnalysis
extends AbstractAnalysis {
    private AttributeMode mode;
    private Class cls;
    private Method accessor = null;
    private Method mutator = null;
    private OperationAnalysis accessorAnalysis = null;
    private OperationAnalysis mutatorAnalysis = null;

    private AttributeAnalysis(Class<?> definingClass, String javaName, AttributeMode mode, Method accessor, Method mutator) throws RMIIIOPViolationException {
        super(Util.javaToIDLName(javaName), javaName);
        this.mode = mode;
        this.cls = accessor.getReturnType();
        this.accessor = accessor;
        this.mutator = mutator;
        assert (accessor.getDeclaringClass().isAssignableFrom(definingClass)) : definingClass + " must be a sub-class of " + accessor.getDeclaringClass();
        if (definingClass.isInterface() && Remote.class.isAssignableFrom(definingClass)) {
            this.accessorAnalysis = new OperationAnalysis(accessor);
            if (mutator != null) {
                this.mutatorAnalysis = new OperationAnalysis(mutator);
            }
            this.setIDLName(this.getIDLName());
        }
    }

    AttributeAnalysis(Class<?> definingClass, String javaName, Method accessor) throws RMIIIOPViolationException {
        this(definingClass, javaName, AttributeMode.ATTR_READONLY, accessor, null);
    }

    AttributeAnalysis(Class<?> definingClass, String javaName, Method accessor, Method mutator) throws RMIIIOPViolationException {
        this(definingClass, javaName, AttributeMode.ATTR_NORMAL, accessor, mutator);
    }

    public AttributeMode getMode() {
        return this.mode;
    }

    public Class getCls() {
        return this.cls;
    }

    public Method getAccessor() {
        return this.accessor;
    }

    public Method getMutator() {
        return this.mutator;
    }

    public OperationAnalysis getAccessorAnalysis() {
        return this.accessorAnalysis;
    }

    public OperationAnalysis getMutatorAnalysis() {
        return this.mutatorAnalysis;
    }

    @Override
    void setIDLName(String idlName) {
        super.setIDLName(idlName);
        if (idlName.charAt(0) >= 'A' && idlName.charAt(0) <= 'Z' && (idlName.length() <= 1 || idlName.charAt(1) < 'A' || idlName.charAt(1) > 'Z')) {
            idlName = idlName.substring(0, 1).toLowerCase() + idlName.substring(1);
        }
        if (this.accessorAnalysis != null) {
            this.accessorAnalysis.setIDLName("_get_" + idlName);
        }
        if (this.mutatorAnalysis != null) {
            this.mutatorAnalysis.setIDLName("_set_" + idlName);
        }
    }
}

