/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.orbportability;

import com.arjuna.orbportability.OA;
import com.arjuna.orbportability.ORB;
import com.arjuna.orbportability.event.EventManager;
import com.arjuna.orbportability.logging.opLogger;
import com.arjuna.orbportability.oa.PostShutdown;
import com.arjuna.orbportability.oa.PreShutdown;
import com.arjuna.orbportability.oa.Shutdown;
import java.util.Enumeration;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.Servant;

public class RootOA
extends OA {
    public static final String DEFAULT_ROOT_NAME = "RootPOA";

    RootOA(ORB orb) {
        super(orb, DEFAULT_ROOT_NAME);
    }

    public synchronized void destroy() throws SystemException {
        if (opLogger.logger.isDebugEnabled()) {
            opLogger.logger.debug(16L, 4L, 1L, "OA::destroyRootPOA ()");
        }
        if (this._oa.initialised()) {
            Shutdown c;
            Enumeration elements;
            if (!this._preOAShutdown.isEmpty()) {
                elements = this._preOAShutdown.elements();
                while (elements.hasMoreElements()) {
                    c = (PreShutdown)elements.nextElement();
                    if (c == null) continue;
                    ((PreShutdown)c).work();
                    c = null;
                }
            }
            this._oa.destroyRootPOA();
            if (!this._postOAShutdown.isEmpty()) {
                elements = this._postOAShutdown.elements();
                while (elements.hasMoreElements()) {
                    c = (PostShutdown)elements.nextElement();
                    if (c == null) continue;
                    ((PostShutdown)c).work();
                    java.lang.Object var2_2 = null;
                }
            }
        }
    }

    public Object corbaReference(Servant obj) {
        Object objRef = null;
        try {
            objRef = this.corbaReference(obj, this._oa.rootPoa());
        }
        catch (Exception e) {
            objRef = null;
        }
        return objRef;
    }

    public boolean objectIsReady(Servant obj, byte[] id) throws SystemException {
        if (opLogger.logger.isDebugEnabled()) {
            opLogger.logger.debug(16L, 4L, 1L, "RootOA::objectIsReady (Servant, byte[], " + this._oaName + ")");
        }
        try {
            this._oa.rootPoa().activate_object_with_id(id, obj);
        }
        catch (Exception e) {
            if (opLogger.loggerI18N.isWarnEnabled()) {
                opLogger.loggerI18N.warn("com.arjuna.orbportability.OA.exceptioncaughtforobj", new java.lang.Object[]{"objectIsReady", obj, e.toString()});
            }
            return false;
        }
        return true;
    }

    public boolean objectIsReady(Servant obj) throws SystemException {
        if (opLogger.logger.isDebugEnabled()) {
            opLogger.logger.debug(16L, 4L, 1L, "RootOA::objectIsReady (Servant)");
        }
        boolean result = true;
        try {
            boolean invalidPOA = false;
            if (this._oa.initialised()) {
                this._oa.rootPoa().activate_object(obj);
            } else {
                invalidPOA = true;
            }
            if (invalidPOA) {
                if (opLogger.loggerI18N.isWarnEnabled()) {
                    opLogger.loggerI18N.warn("com.arjuna.orbportability.OA.invalidpoa", new java.lang.Object[]{"objectIsReady", "rootPOA"});
                }
                result = false;
            }
            EventManager.getManager().connected(this.corbaReference(obj));
        }
        catch (Exception e) {
            if (opLogger.loggerI18N.isWarnEnabled()) {
                opLogger.loggerI18N.warn("com.arjuna.orbportability.OA.exceptioncaughtforobj", new java.lang.Object[]{"objectIsReady", obj, e.toString()});
            }
            result = false;
        }
        return result;
    }

    public boolean shutdownObject(Object obj) {
        if (opLogger.logger.isDebugEnabled()) {
            opLogger.logger.debug(16L, 4L, 1L, "RootOA::shutdownObject ()");
        }
        boolean result = true;
        try {
            EventManager.getManager().disconnected(obj);
            boolean invalidPOA = false;
            if (this._oa.initialised()) {
                this._oa.rootPoa().deactivate_object(this._oa.rootPoa().reference_to_id(obj));
            } else {
                invalidPOA = true;
            }
            if (invalidPOA) {
                if (opLogger.loggerI18N.isWarnEnabled()) {
                    opLogger.loggerI18N.warn("com.arjuna.orbportability.OA.invalidpoa", new java.lang.Object[]{"objectIsReady", "rootPOA"});
                }
                result = false;
            }
        }
        catch (Exception e) {
            if (opLogger.loggerI18N.isWarnEnabled()) {
                opLogger.loggerI18N.warn("com.arjuna.orbportability.OA.caughtexception", new java.lang.Object[]{"objectIsReady", e.toString()});
            }
            result = false;
        }
        return result;
    }

    public boolean shutdownObject(Servant obj) {
        if (opLogger.logger.isDebugEnabled()) {
            opLogger.logger.debug(16L, 4L, 1L, "RootOA::shutdownObject (Servant)");
        }
        boolean result = true;
        try {
            boolean invalidPOA = false;
            if (this._oa.initialised()) {
                this._oa.rootPoa().deactivate_object(this._oa.rootPoa().servant_to_id(obj));
            } else {
                invalidPOA = true;
            }
            if (invalidPOA) {
                if (opLogger.loggerI18N.isWarnEnabled()) {
                    opLogger.loggerI18N.warn("com.arjuna.orbportability.OA.invalidpoa", new java.lang.Object[]{"shutdownObject", "rootPOA"});
                }
                result = false;
            }
        }
        catch (NullPointerException ex) {
        }
        catch (Exception e) {
            if (!(e instanceof OBJECT_NOT_EXIST) && opLogger.loggerI18N.isWarnEnabled()) {
                opLogger.loggerI18N.warn("com.arjuna.orbportability.OA.caughtexception", new java.lang.Object[]{"shutdownObject", e.toString()});
            }
            result = false;
        }
        return result;
    }
}

