/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.ws.WebServiceException;
import org.jboss.logging.Logger;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.binding.ComplexTypeSerializer;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.ws.core.jaxws.JAXBBindingCustomization;
import org.jboss.ws.core.jaxws.JAXBContextCache;
import org.jboss.ws.core.jaxws.JAXBContextFactory;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.extensions.xop.jaxws.AttachmentMarshallerImpl;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.util.xml.BufferedStreamResult;
import org.jboss.wsf.spi.binding.BindingCustomization;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBSerializer
extends ComplexTypeSerializer {
    private static final Logger log = Logger.getLogger(JAXBSerializer.class);

    @Override
    public Result serialize(QName xmlName, QName xmlType, Object value, SerializationContext serContext, NamedNodeMap attributes) throws BindingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]"));
        }
        BufferedStreamResult result = null;
        try {
            Class expectedType = serContext.getJavaType();
            Class[] types = this.getClassesForContextCreation(serContext, value);
            JAXBContext jaxbContext = this.getJAXBContext(types);
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.setAttachmentMarshaller((AttachmentMarshaller)new AttachmentMarshallerImpl());
            result = new BufferedStreamResult();
            marshaller.marshal((Object)new JAXBElement(xmlName, expectedType, value), (Result)result);
            if (log.isDebugEnabled()) {
                log.debug((Object)("serialized: " + result));
            }
        }
        catch (Exception ex) {
            this.handleMarshallException(ex);
        }
        return result;
    }

    private Class[] getClassesForContextCreation(SerializationContext serContext, Object value) {
        Class[] classArray;
        Class expectedType = serContext.getJavaType();
        Class<?> actualType = value.getClass();
        if (this.shouldFilter(actualType)) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = expectedType;
        } else {
            Class[] classArray3 = new Class[2];
            classArray3[0] = expectedType;
            classArray = classArray3;
            classArray3[1] = actualType;
        }
        Class[] types = classArray;
        Class[] registeredTypes = (Class[])serContext.getProperty("org.jboss.ws.jaxb.context.types");
        List<Class> typesList = Arrays.asList(registeredTypes);
        return typesList.containsAll(Arrays.asList(types)) ? registeredTypes : types;
    }

    private JAXBContext getJAXBContext(Class[] types) {
        JAXBContextCache cache = JAXBContextCache.getContextCache();
        JAXBContext context = cache.get(types);
        if (null == context) {
            CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
            EndpointMetaData epMetaData = msgContext.getEndpointMetaData();
            String defaultNS = epMetaData.getPortTypeName().getNamespaceURI();
            BindingCustomization bindingCustomization = this.getBindingCustomization();
            for (Class clz : types) {
                if (!clz.getName().endsWith("ObjectFactory")) continue;
                for (Method meth : clz.getMethods()) {
                    XmlElementDecl elementDecl = meth.getAnnotation(XmlElementDecl.class);
                    if (elementDecl == null || !XmlElementDecl.GLOBAL.class.equals((Object)elementDecl.scope()) || elementDecl.namespace() == null || elementDecl.namespace().length() <= 0) continue;
                    defaultNS = null;
                }
            }
            if (defaultNS != null) {
                if (bindingCustomization == null) {
                    bindingCustomization = new JAXBBindingCustomization();
                }
                bindingCustomization.put((Object)"com.sun.xml.bind.defaultNamespaceRemap", (Object)defaultNS);
            }
            context = JAXBContextFactory.newInstance().createContext(types, bindingCustomization);
            cache.add(types, context);
        }
        return context;
    }

    private boolean shouldFilter(Class<?> actualType) {
        return XMLGregorianCalendar.class.isAssignableFrom(actualType);
    }

    private void handleMarshallException(Exception ex) {
        if (ex instanceof WebServiceException) {
            throw (WebServiceException)ex;
        }
        throw new WebServiceException((Throwable)ex);
    }
}

