/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.impl;

import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.Reference;
import org.jboss.cache.pojo.collection.CachedArray;
import org.jboss.cache.pojo.collection.CachedArrayRegistry;
import org.jboss.cache.pojo.impl.AbstractHandler;
import org.jboss.cache.pojo.impl.InternalHelper;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.jboss.cache.pojo.impl.PojoInstance;
import org.jboss.cache.pojo.impl.PojoUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayHandler
extends AbstractHandler {
    private final PojoCacheImpl cache;
    private final PojoUtil util = new PojoUtil();

    ArrayHandler(PojoCacheImpl cache) {
        this.cache = cache;
    }

    @Override
    protected Fqn<?> getFqn(Object array) {
        CachedArray cached = CachedArrayRegistry.lookup(array);
        return cached != null ? cached.getFqn() : null;
    }

    @Override
    protected void put(Fqn<?> fqn, Reference reference, Object obj) {
        PojoInstance pojoInstance = InternalHelper.initializeAopInstance(reference);
        pojoInstance.set(obj);
        pojoInstance.setPojoClass(obj.getClass());
        this.cache.getCache().put(fqn, (Object)"POJOCache.PojoInstance", (Object)pojoInstance);
        CachedArray cached = CachedArray.create(fqn, this.cache, obj);
        this.util.attachArray(obj, cached);
    }

    @Override
    protected Object get(Fqn<?> fqn, Class<?> clazz, PojoInstance pojo) {
        CachedArray cached = CachedArray.load(fqn, this.cache, clazz);
        Object array = cached.toArray();
        CachedArrayRegistry.register(array, cached);
        return array;
    }

    @Override
    protected Object remove(Fqn<?> fqn, Reference referencingFqn, Object obj) {
        CachedArray cached = CachedArrayRegistry.lookup(obj);
        if (cached != null) {
            this.util.detachArray(obj, cached);
            cached.destroy();
        }
        return obj;
    }

    @Override
    protected boolean handles(Class<?> clazz) {
        return clazz.isArray();
    }
}

