/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Projection;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public class SQLProjection
implements Projection {
    private final String sql;
    private final String groupBy;
    private final Type[] types;
    private String[] aliases;
    private String[] columnAliases;
    private boolean grouped;

    @Override
    public String toSqlString(Criteria criteria, int loc, CriteriaQuery criteriaQuery) throws HibernateException {
        return StringHelper.replace(this.sql, "{alias}", criteriaQuery.getSQLAlias(criteria));
    }

    @Override
    public String toGroupSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        return StringHelper.replace(this.groupBy, "{alias}", criteriaQuery.getSQLAlias(criteria));
    }

    @Override
    public Type[] getTypes(Criteria crit, CriteriaQuery criteriaQuery) throws HibernateException {
        return this.types;
    }

    public String toString() {
        return this.sql;
    }

    protected SQLProjection(String sql, String[] columnAliases, Type[] types) {
        this(sql, null, columnAliases, types);
    }

    protected SQLProjection(String sql, String groupBy, String[] columnAliases, Type[] types) {
        this.sql = sql;
        this.types = types;
        this.aliases = columnAliases;
        this.columnAliases = columnAliases;
        this.grouped = groupBy != null;
        this.groupBy = groupBy;
    }

    @Override
    public String[] getAliases() {
        return this.aliases;
    }

    @Override
    public String[] getColumnAliases(int loc) {
        return this.columnAliases;
    }

    @Override
    public boolean isGrouped() {
        return this.grouped;
    }

    @Override
    public Type[] getTypes(String alias, Criteria crit, CriteriaQuery criteriaQuery) {
        return null;
    }

    @Override
    public String[] getColumnAliases(String alias, int loc) {
        return null;
    }
}

