/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Node;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.EntityUniqueKey;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.UniqueKeyLoadable;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.tuple.ElementWrapper;
import org.hibernate.type.AbstractType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.util.ReflectHelper;

public abstract class EntityType
extends AbstractType
implements AssociationType {
    private final String associatedEntityName;
    protected final String uniqueKeyPropertyName;
    protected final boolean isEmbeddedInXML;
    private final boolean eager;
    private final boolean unwrapProxy;
    private transient Class returnedClass;

    protected EntityType(String entityName, String uniqueKeyPropertyName, boolean eager, boolean isEmbeddedInXML, boolean unwrapProxy) {
        this.associatedEntityName = entityName;
        this.uniqueKeyPropertyName = uniqueKeyPropertyName;
        this.isEmbeddedInXML = isEmbeddedInXML;
        this.eager = eager;
        this.unwrapProxy = unwrapProxy;
    }

    @Override
    public boolean isAssociationType() {
        return true;
    }

    @Override
    public final boolean isEntityType() {
        return true;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.getAssociatedEntityName() + ')';
    }

    @Override
    public String getName() {
        return this.associatedEntityName;
    }

    public boolean isReferenceToPrimaryKey() {
        return this.uniqueKeyPropertyName == null;
    }

    @Override
    public String getRHSUniqueKeyPropertyName() {
        return this.uniqueKeyPropertyName;
    }

    @Override
    public String getLHSPropertyName() {
        return null;
    }

    public String getPropertyName() {
        return null;
    }

    public final String getAssociatedEntityName() {
        return this.associatedEntityName;
    }

    @Override
    public String getAssociatedEntityName(SessionFactoryImplementor factory) {
        return this.getAssociatedEntityName();
    }

    @Override
    public Joinable getAssociatedJoinable(SessionFactoryImplementor factory) throws MappingException {
        return (Joinable)((Object)factory.getEntityPersister(this.associatedEntityName));
    }

    @Override
    public final Class getReturnedClass() {
        if (this.returnedClass == null) {
            this.returnedClass = this.determineAssociatedEntityClass();
        }
        return this.returnedClass;
    }

    private Class determineAssociatedEntityClass() {
        try {
            return ReflectHelper.classForName(this.getAssociatedEntityName());
        }
        catch (ClassNotFoundException cnfe) {
            return Map.class;
        }
    }

    @Override
    public Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, new String[]{name}, session, owner);
    }

    @Override
    public final Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.resolve(this.hydrate(rs, names, session, owner), session, owner);
    }

    @Override
    public final boolean isSame(Object x, Object y, EntityMode entityMode) {
        return x == y;
    }

    @Override
    public int compare(Object x, Object y, EntityMode entityMode) {
        return 0;
    }

    @Override
    public Object deepCopy(Object value, EntityMode entityMode, SessionFactoryImplementor factory) {
        return value;
    }

    @Override
    public Object replace(Object original, Object target, SessionImplementor session, Object owner, Map copyCache) throws HibernateException {
        if (original == null) {
            return null;
        }
        Object cached = copyCache.get(original);
        if (cached != null) {
            return cached;
        }
        if (original == target) {
            return target;
        }
        if (session.getContextEntityIdentifier(original) == null && ForeignKeys.isTransient(this.associatedEntityName, original, Boolean.FALSE, session)) {
            Object copy = session.getFactory().getEntityPersister(this.associatedEntityName).instantiate(null, session.getEntityMode());
            copyCache.put(original, copy);
            return copy;
        }
        Object id = this.getIdentifier(original, session);
        if (id == null) {
            throw new AssertionFailure("non-transient entity has a null id");
        }
        id = this.getIdentifierOrUniqueKeyType(session.getFactory()).replace(id, null, session, owner, copyCache);
        return this.resolve(id, session, owner);
    }

    @Override
    public int getHashCode(Object x, EntityMode entityMode, SessionFactoryImplementor factory) {
        EntityPersister persister = factory.getEntityPersister(this.associatedEntityName);
        if (!persister.canExtractIdOutOfEntity()) {
            return super.getHashCode(x, entityMode);
        }
        Serializable id = x instanceof HibernateProxy ? ((HibernateProxy)x).getHibernateLazyInitializer().getIdentifier() : persister.getIdentifier(x, entityMode);
        return persister.getIdentifierType().getHashCode(id, entityMode, factory);
    }

    @Override
    public boolean isEqual(Object x, Object y, EntityMode entityMode, SessionFactoryImplementor factory) {
        EntityPersister persister = factory.getEntityPersister(this.associatedEntityName);
        if (!persister.canExtractIdOutOfEntity()) {
            return super.isEqual(x, y, entityMode);
        }
        Serializable xid = x instanceof HibernateProxy ? ((HibernateProxy)x).getHibernateLazyInitializer().getIdentifier() : persister.getIdentifier(x, entityMode);
        Serializable yid = y instanceof HibernateProxy ? ((HibernateProxy)y).getHibernateLazyInitializer().getIdentifier() : persister.getIdentifier(y, entityMode);
        return persister.getIdentifierType().isEqual(xid, yid, entityMode, factory);
    }

    @Override
    public boolean isEmbeddedInXML() {
        return this.isEmbeddedInXML;
    }

    @Override
    public boolean isXMLElement() {
        return this.isEmbeddedInXML;
    }

    @Override
    public Object fromXMLNode(Node xml, Mapping factory) throws HibernateException {
        if (!this.isEmbeddedInXML) {
            return this.getIdentifierType(factory).fromXMLNode(xml, factory);
        }
        return xml;
    }

    @Override
    public void setToXMLNode(Node node, Object value, SessionFactoryImplementor factory) throws HibernateException {
        if (!this.isEmbeddedInXML) {
            this.getIdentifierType(factory).setToXMLNode(node, value, factory);
        } else {
            Element elt = (Element)value;
            EntityType.replaceNode(node, new ElementWrapper(elt));
        }
    }

    @Override
    public String getOnCondition(String alias, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        if (this.isReferenceToPrimaryKey()) {
            return "";
        }
        return this.getAssociatedJoinable(factory).filterFragment(alias, enabledFilters);
    }

    @Override
    public Object resolve(Object value, SessionImplementor session, Object owner) throws HibernateException {
        if (this.isNotEmbedded(session)) {
            return value;
        }
        if (value == null) {
            return null;
        }
        if (this.isNull(owner, session)) {
            return null;
        }
        if (this.isReferenceToPrimaryKey()) {
            return this.resolveIdentifier((Serializable)value, session);
        }
        return this.loadByUniqueKey(this.getAssociatedEntityName(), this.uniqueKeyPropertyName, value, session);
    }

    @Override
    public Type getSemiResolvedType(SessionFactoryImplementor factory) {
        return factory.getEntityPersister(this.associatedEntityName).getIdentifierType();
    }

    protected final Object getIdentifier(Object value, SessionImplementor session) throws HibernateException {
        if (this.isNotEmbedded(session)) {
            return value;
        }
        if (this.isReferenceToPrimaryKey()) {
            return ForeignKeys.getEntityIdentifierIfNotUnsaved(this.getAssociatedEntityName(), value, session);
        }
        if (value == null) {
            return null;
        }
        EntityPersister entityPersister = session.getFactory().getEntityPersister(this.getAssociatedEntityName());
        Object propertyValue = entityPersister.getPropertyValue(value, this.uniqueKeyPropertyName, session.getEntityMode());
        Type type = entityPersister.getPropertyType(this.uniqueKeyPropertyName);
        if (type.isEntityType()) {
            propertyValue = ((EntityType)type).getIdentifier(propertyValue, session);
        }
        return propertyValue;
    }

    protected boolean isNotEmbedded(SessionImplementor session) {
        return !this.isEmbeddedInXML && session.getEntityMode() == EntityMode.DOM4J;
    }

    private static Serializable getIdentifier(Object object, EntityPersister persister, EntityMode entityMode) {
        if (object instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)object;
            LazyInitializer li = proxy.getHibernateLazyInitializer();
            return li.getIdentifier();
        }
        return persister.getIdentifier(object, entityMode);
    }

    @Override
    public String toLoggableString(Object value, SessionFactoryImplementor factory) {
        if (value == null) {
            return "null";
        }
        EntityPersister persister = factory.getEntityPersister(this.associatedEntityName);
        StringBuffer result = new StringBuffer().append(this.associatedEntityName);
        if (persister.hasIdentifierProperty()) {
            Serializable id;
            EntityMode entityMode = persister.guessEntityMode(value);
            if (entityMode == null) {
                if (this.isEmbeddedInXML) {
                    throw new ClassCastException(value.getClass().getName());
                }
                id = (Serializable)value;
            } else {
                id = EntityType.getIdentifier(value, persister, entityMode);
            }
            result.append('#').append(persister.getIdentifierType().toLoggableString(id, factory));
        }
        return result.toString();
    }

    public abstract boolean isOneToOne();

    Type getIdentifierType(Mapping factory) {
        return factory.getIdentifierType(this.getAssociatedEntityName());
    }

    Type getIdentifierType(SessionImplementor session) {
        return this.getIdentifierType(session.getFactory());
    }

    public final Type getIdentifierOrUniqueKeyType(Mapping factory) throws MappingException {
        if (this.isReferenceToPrimaryKey()) {
            return this.getIdentifierType(factory);
        }
        Type type = factory.getReferencedPropertyType(this.getAssociatedEntityName(), this.uniqueKeyPropertyName);
        if (type.isEntityType()) {
            type = ((EntityType)type).getIdentifierOrUniqueKeyType(factory);
        }
        return type;
    }

    public final String getIdentifierOrUniqueKeyPropertyName(Mapping factory) throws MappingException {
        if (this.isReferenceToPrimaryKey()) {
            return factory.getIdentifierPropertyName(this.getAssociatedEntityName());
        }
        return this.uniqueKeyPropertyName;
    }

    protected abstract boolean isNullable();

    protected final Object resolveIdentifier(Serializable id, SessionImplementor session) throws HibernateException {
        boolean isProxyUnwrapEnabled = this.unwrapProxy && session.getFactory().getEntityPersister(this.getAssociatedEntityName()).isInstrumented(session.getEntityMode());
        Object proxyOrEntity = session.internalLoad(this.getAssociatedEntityName(), id, this.eager, this.isNullable() && !isProxyUnwrapEnabled);
        if (proxyOrEntity instanceof HibernateProxy) {
            ((HibernateProxy)proxyOrEntity).getHibernateLazyInitializer().setUnwrap(isProxyUnwrapEnabled);
        }
        return proxyOrEntity;
    }

    protected boolean isNull(Object owner, SessionImplementor session) {
        return false;
    }

    public Object loadByUniqueKey(String entityName, String uniqueKeyPropertyName, Object key, SessionImplementor session) throws HibernateException {
        SessionFactoryImplementor factory = session.getFactory();
        UniqueKeyLoadable persister = (UniqueKeyLoadable)factory.getEntityPersister(entityName);
        EntityUniqueKey euk = new EntityUniqueKey(entityName, uniqueKeyPropertyName, key, this.getIdentifierOrUniqueKeyType(factory), session.getEntityMode(), session.getFactory());
        PersistenceContext persistenceContext = session.getPersistenceContext();
        Object result = persistenceContext.getEntity(euk);
        if (result == null) {
            result = persister.loadByUniqueKey(uniqueKeyPropertyName, key, session);
        }
        return result == null ? null : persistenceContext.proxyFor(result);
    }
}

