/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded.manager.history;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jboss.on.embedded.manager.history.HistoryManager;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHistoryManager<T>
implements HistoryManager<T> {
    protected Map<ResourceType, Collection<T>> historyByResourceType = new HashMap<ResourceType, Collection<T>>();
    protected Map<Resource, Collection<T>> historyByResource = new HashMap<Resource, Collection<T>>();
    protected Map<String, T> historyByJobId = new HashMap<String, T>();

    protected abstract String getJobId(T var1);

    protected void addToMaps(T history, Resource resource, ResourceType resourceType) {
        String jobId = this.getJobId(history);
        this.historyByJobId.put(jobId, history);
        Collection<T> listOfHistoryByResourceTypes = this.historyByResourceType.get(resourceType);
        if (listOfHistoryByResourceTypes == null) {
            listOfHistoryByResourceTypes = new ArrayList<T>();
            this.historyByResourceType.put(resourceType, listOfHistoryByResourceTypes);
        }
        listOfHistoryByResourceTypes.add(history);
        Collection<T> listOfHistoryByResources = this.historyByResource.get(resource);
        if (listOfHistoryByResources == null) {
            listOfHistoryByResources = new ArrayList<T>();
            this.historyByResource.put(resource, listOfHistoryByResources);
        }
        listOfHistoryByResources.add(history);
    }

    @Override
    public T getHistory(String historyId) {
        return this.historyByJobId.get(historyId);
    }

    @Override
    public Collection<T> getAllHistory() {
        return this.historyByJobId.values();
    }

    @Override
    public Collection<T> getHistoryForResourceType(ResourceType resourceType) {
        return this.historyByResourceType.get(resourceType);
    }

    @Override
    public Collection<T> getHistoryForResource(Resource resource) {
        return this.historyByResource.get(resource);
    }
}

