/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.action.CollectionAction;
import org.hibernate.cache.CacheException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.event.PostCollectionRecreateEvent;
import org.hibernate.event.PostCollectionRecreateEventListener;
import org.hibernate.event.PreCollectionRecreateEvent;
import org.hibernate.event.PreCollectionRecreateEventListener;
import org.hibernate.persister.collection.CollectionPersister;

public final class CollectionRecreateAction
extends CollectionAction {
    public CollectionRecreateAction(PersistentCollection collection, CollectionPersister persister, Serializable id, SessionImplementor session) throws CacheException {
        super(persister, collection, id, session);
    }

    @Override
    public void execute() throws HibernateException {
        PersistentCollection collection = this.getCollection();
        this.preRecreate();
        this.getPersister().recreate(collection, this.getKey(), this.getSession());
        this.getSession().getPersistenceContext().getCollectionEntry(collection).afterAction(collection);
        this.evict();
        this.postRecreate();
        if (this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
            this.getSession().getFactory().getStatisticsImplementor().recreateCollection(this.getPersister().getRole());
        }
    }

    private void preRecreate() {
        PreCollectionRecreateEventListener[] preListeners = this.getSession().getListeners().getPreCollectionRecreateEventListeners();
        if (preListeners.length > 0) {
            PreCollectionRecreateEvent preEvent = new PreCollectionRecreateEvent(this.getPersister(), this.getCollection(), (EventSource)this.getSession());
            for (int i = 0; i < preListeners.length; ++i) {
                preListeners[i].onPreRecreateCollection(preEvent);
            }
        }
    }

    private void postRecreate() {
        PostCollectionRecreateEventListener[] postListeners = this.getSession().getListeners().getPostCollectionRecreateEventListeners();
        if (postListeners.length > 0) {
            PostCollectionRecreateEvent postEvent = new PostCollectionRecreateEvent(this.getPersister(), this.getCollection(), (EventSource)this.getSession());
            for (int i = 0; i < postListeners.length; ++i) {
                postListeners[i].onPostRecreateCollection(postEvent);
            }
        }
    }
}

