/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transform;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.hibernate.transform.BasicTransformerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistinctResultTransformer
extends BasicTransformerAdapter {
    public static final DistinctResultTransformer INSTANCE = new DistinctResultTransformer();
    private static final Logger log = LoggerFactory.getLogger(DistinctResultTransformer.class);

    private DistinctResultTransformer() {
    }

    @Override
    public List transformList(List list) {
        ArrayList result = new ArrayList(list.size());
        HashSet<Identity> distinct = new HashSet<Identity>();
        for (int i = 0; i < list.size(); ++i) {
            Object entity = list.get(i);
            if (!distinct.add(new Identity(entity))) continue;
            result.add(entity);
        }
        if (log.isDebugEnabled()) {
            log.debug("transformed: " + list.size() + " rows to: " + result.size() + " distinct results");
        }
        return result;
    }

    private Object readResolve() {
        return INSTANCE;
    }

    private static final class Identity {
        final Object entity;

        private Identity(Object entity) {
            this.entity = entity;
        }

        public boolean equals(Object other) {
            return Identity.class.isInstance(other) && this.entity == ((Identity)other).entity;
        }

        public int hashCode() {
            return System.identityHashCode(this.entity);
        }
    }
}

