/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.filter;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.jboss.logging.filter.AbstractTCLFilter;

public class TCLFilter
extends AbstractTCLFilter {
    protected boolean matchClassLoader(ClassLoader cl) {
        URL[] urls;
        for (URL u : urls = TCLFilter.getClassLoaderURLs(cl)) {
            String file = u.getFile();
            if (file.indexOf(this.getDeployURL()) <= 0) continue;
            return true;
        }
        return false;
    }

    private static URL[] getClassLoaderURLs(ClassLoader cl) {
        URL[] urls = new URL[]{};
        try {
            if (cl instanceof URLClassLoader) {
                URLClassLoader urlClassloader = (URLClassLoader)cl;
                urls = urlClassloader.getURLs();
            } else {
                Object[] args;
                Class<?> returnType = urls.getClass();
                Class[] parameterTypes = new Class[]{};
                Method getURLs = cl.getClass().getMethod("getURLs", parameterTypes);
                if (returnType.isAssignableFrom(getURLs.getReturnType())) {
                    args = new Object[]{};
                    urls = (URL[])getURLs.invoke((Object)cl, args);
                }
                if ((urls == null || urls.length == 0) && returnType.isAssignableFrom((getURLs = cl.getClass().getMethod("getClasspath", parameterTypes)).getReturnType())) {
                    args = new Object[]{};
                    urls = (URL[])getURLs.invoke((Object)cl, args);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return urls;
    }
}

