/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.ejb3.DeploymentUnit;
import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
import org.jboss.ejb3.vfs.impl.vfs2.VirtualFileFilterAdapter;
import org.jboss.ejb3.vfs.impl.vfs2.VirtualFileWrapper;
import org.jboss.ejb3.vfs.spi.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VirtualFileVisitor;
import org.jboss.virtual.VisitorAttributes;
import org.jboss.virtual.plugins.context.jar.JarUtils;
import org.jboss.virtual.plugins.vfs.helpers.FilterVirtualFileVisitor;
import org.jboss.virtual.plugins.vfs.helpers.SuffixesExcludeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBoss5DeploymentUnit
implements DeploymentUnit {
    private VFSDeploymentUnit unit;
    private ClassLoader classLoader;
    private Map defaultPersistenceProperties;

    public JBoss5DeploymentUnit(VFSDeploymentUnit unit) {
        this(unit, unit.getClassLoader());
    }

    public JBoss5DeploymentUnit(VFSDeploymentUnit unit, ClassLoader classLoader) {
        assert (unit != null) : "unit is null";
        assert (classLoader != null) : "classLoader is null";
        this.unit = unit;
        this.classLoader = classLoader;
    }

    public Object addAttachment(String name, Object attachment) {
        return this.unit.addAttachment(name, attachment);
    }

    public Object getAttachment(String name) {
        return this.unit.getAttachment(name);
    }

    public Object removeAttachment(String name) {
        return this.unit.removeAttachment(name);
    }

    public VirtualFile getRootFile() {
        return new VirtualFileWrapper(this.unit.getFile(""));
    }

    public String getRelativePath() {
        return this.unit.getRelativePath();
    }

    public URL getRelativeURL(String jar) {
        try {
            return new URL(jar);
        }
        catch (MalformedURLException e) {
            try {
                if (this.getUrl() == null) {
                    throw new RuntimeException("relative <jar-file> not allowed when standalone deployment unit is used");
                }
                return new URL(this.getUrl(), jar);
            }
            catch (Exception e1) {
                throw new RuntimeException("could not find relative path: " + jar, e1);
            }
        }
    }

    URL extractDescriptorUrl(String resource) {
        try {
            org.jboss.virtual.VirtualFile vf = this.unit.getMetaDataFile(resource);
            if (vf == null) {
                return null;
            }
            return vf.toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public URL getPersistenceXml() {
        return this.extractDescriptorUrl("persistence.xml");
    }

    public URL getEjbJarXml() {
        return this.extractDescriptorUrl("ejb-jar.xml");
    }

    public URL getJbossXml() {
        return this.extractDescriptorUrl("jboss.xml");
    }

    public VirtualFile getMetaDataFile(String name) {
        return new VirtualFileWrapper(this.unit.getMetaDataFile(name));
    }

    public List<Class> getClasses() {
        return null;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClassLoader getResourceLoader() {
        return this.getClassLoader();
    }

    public String getShortName() {
        return this.unit.getFile("").getName();
    }

    public URL getUrl() {
        try {
            return this.unit.getFile("").toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getDefaultEntityManagerName() {
        String url = this.getUrl().toString();
        String name = url.substring(url.lastIndexOf(47) + 1, url.lastIndexOf(46));
        return name;
    }

    public Map getDefaultPersistenceProperties() {
        return this.defaultPersistenceProperties;
    }

    public void setDefaultPersistenceProperties(Map defaultPersistenceProperties) {
        this.defaultPersistenceProperties = defaultPersistenceProperties;
    }

    public Hashtable getJndiProperties() {
        return null;
    }

    @Deprecated
    public InterceptorInfoRepository getInterceptorInfoRepository() {
        throw new IllegalStateException("EJBTHREE-1852: InterceptorInfoRepository must not be used anymore");
    }

    public List<VirtualFile> getResources(org.jboss.ejb3.vfs.spi.VirtualFileFilter filter) {
        List classPath = this.unit.getClassPath();
        if (classPath == null || classPath.isEmpty()) {
            return Collections.emptyList();
        }
        VisitorAttributes va = new VisitorAttributes();
        va.setLeavesOnly(true);
        SuffixesExcludeFilter noJars = new SuffixesExcludeFilter((Collection)JarUtils.getSuffixes());
        va.setRecurseFilter((VirtualFileFilter)noJars);
        FilterVirtualFileVisitor visitor = new FilterVirtualFileVisitor((VirtualFileFilter)new VirtualFileFilterAdapter(filter), va);
        for (org.jboss.virtual.VirtualFile root : classPath) {
            try {
                if (root.isLeaf()) continue;
                root.visit((VirtualFileVisitor)visitor);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        List matches = visitor.getMatched();
        ArrayList<VirtualFile> wrappedMatches = new ArrayList<VirtualFile>(matches.size());
        for (org.jboss.virtual.VirtualFile match : matches) {
            wrappedMatches.add((VirtualFile)new VirtualFileWrapper(match));
        }
        return wrappedMatches;
    }
}

