/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.quartz.inflow;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;

class SecurityActions {
    private SecurityActions() {
    }

    static void startScheduler(final Scheduler schd) throws SchedulerException {
        Object exception = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    schd.start();
                    return null;
                }
                catch (SchedulerException se) {
                    return se;
                }
            }
        });
        if (exception != null) {
            throw (SchedulerException)((Object)exception);
        }
    }

    static void shutdownScheduler(final Scheduler schd) throws SchedulerException {
        Object exception = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    schd.shutdown(true);
                    return null;
                }
                catch (SchedulerException se) {
                    return se;
                }
            }
        });
        if (exception != null) {
            throw (SchedulerException)((Object)exception);
        }
    }
}

