/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.event.Event;
import org.rhq.core.pluginapi.event.EventPoller;
import org.rhq.core.pluginapi.event.log.LogEntryProcessor;
import org.rhq.core.pluginapi.event.log.LogFileEventPoller;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.platform.SyslogProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyslogFileEventLogDelegate
extends SyslogProcessor
implements LogEntryProcessor {
    private final Log log = LogFactory.getLog(SyslogFileEventLogDelegate.class);
    private String file;
    private LogFileEventPoller poller;

    public SyslogFileEventLogDelegate(ResourceContext resourceContext, PropertyMap logProperties) {
        super(resourceContext, logProperties, SyslogFileEventLogDelegate.getFileFromPropertyMap(logProperties));
        this.file = SyslogFileEventLogDelegate.getFileFromPropertyMap(logProperties);
        try {
            this.poller = new LogFileEventPoller(this.getEventContext(), "Event Log", new File(this.file), (LogEntryProcessor)this);
            this.getEventContext().registerEventPoller((EventPoller)this.poller, 60, this.poller.getSourceLocation());
        }
        catch (Exception e) {
            this.log.error((Object)"Failed attempt to setup syslog file poller. Cannot process syslog messages.", (Throwable)e);
        }
    }

    private static String getFileFromPropertyMap(PropertyMap logProperties) {
        return logProperties.getSimpleValue("logTrackingFilePath", "/var/log/messages");
    }

    public void shutdown() {
        if (this.poller != null) {
            this.getEventContext().unregisterEventPoller(this.poller.getEventType(), this.poller.getSourceLocation());
        }
    }

    public Set<Event> processLines(BufferedReader bufferedReader) throws IOException {
        String line;
        LinkedHashSet<Event> events = new LinkedHashSet<Event>();
        while ((line = bufferedReader.readLine()) != null) {
            Event event = this.convertLine(line);
            if (event == null) continue;
            events.add(event);
        }
        return events;
    }
}

