/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.jboss.beans.metadata.plugins.AbstractFeatureMetaData;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.plugins.CloneUtil;
import org.jboss.beans.metadata.plugins.builder.MutableParameterizedMetaData;
import org.jboss.beans.metadata.spi.LifecycleMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlType(name="lifecycleType", propOrder={"annotations", "parameters"})
public class AbstractLifecycleMetaData
extends AbstractFeatureMetaData
implements LifecycleMetaData,
MutableParameterizedMetaData,
Serializable {
    private static final long serialVersionUID = 2L;
    protected ControllerState state;
    protected String methodName;
    boolean ignored;
    protected List<ParameterMetaData> parameters;
    protected String type;

    public AbstractLifecycleMetaData() {
    }

    public AbstractLifecycleMetaData(String methodName) {
        this.methodName = methodName;
    }

    @Override
    public ControllerState getState() {
        return this.state;
    }

    @Override
    @XmlAttribute(name="whenRequired")
    public void setState(ControllerState state) {
        this.state = state;
        this.flushJBossObjectCache();
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    @XmlAttribute(name="method")
    public void setMethodName(String name) {
        this.methodName = name;
        this.flushJBossObjectCache();
    }

    @Override
    public boolean isIgnored() {
        return this.ignored;
    }

    @XmlAttribute
    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    @Override
    public List<ParameterMetaData> getParameters() {
        return this.parameters;
    }

    @Override
    @XmlElement(name="parameter", type=AbstractParameterMetaData.class)
    public void setParameters(List<ParameterMetaData> parameters) {
        this.parameters = parameters;
        this.flushJBossObjectCache();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void initialVisit(MetaDataVisitor visitor) {
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                this.parameters.get(i).setIndex(i);
            }
        }
        visitor.setContextState(this.state);
        super.initialVisit(visitor);
    }

    @Override
    protected void addChildren(Set<MetaDataVisitorNode> children) {
        super.addChildren(children);
        if (this.parameters != null) {
            children.addAll(this.parameters);
        }
    }

    @Override
    public TypeInfo getType(MetaDataVisitor visitor, MetaDataVisitorNode previous) throws Throwable {
        if (!(previous instanceof ParameterMetaData)) {
            throw new IllegalArgumentException("Previous node is not ParameterMetaData as expected: " + previous);
        }
        ParameterMetaData parameter = (ParameterMetaData)previous;
        KernelControllerContext context = visitor.getControllerContext();
        String method = this.methodName != null ? this.methodName : this.type;
        String[] parameterTypes = Configurator.getParameterTypes(false, this.parameters);
        MethodInfo methodInfo = Configurator.findMethodInfo((ClassInfo)this.getClassInfo(context), (String)method, (String[])parameterTypes);
        return this.applyCollectionOrMapCheck(methodInfo.getParameterTypes()[parameter.getIndex()]);
    }

    protected ClassInfo getClassInfo(KernelControllerContext context) throws Throwable {
        return context.getBeanInfo().getClassInfo();
    }

    @Override
    public void toString(JBossStringBuilder buffer) {
        if (this.methodName != null) {
            buffer.append("method=").append(this.methodName);
        }
        buffer.append(" whenRequired=").append((Object)this.state);
        buffer.append(" parameters=");
        JBossObject.list((JBossStringBuilder)buffer, this.parameters);
        buffer.append(" ");
        super.toString(buffer);
    }

    @Override
    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.methodName);
    }

    @Override
    public AbstractLifecycleMetaData clone() {
        AbstractLifecycleMetaData clone = (AbstractLifecycleMetaData)super.clone();
        this.doClone(clone);
        return clone;
    }

    protected void doClone(AbstractLifecycleMetaData clone) {
        super.doClone(clone);
        clone.setIgnored(this.ignored);
        clone.setMethodName(this.methodName);
        clone.setParameters(CloneUtil.cloneList(this.parameters, ArrayList.class, ParameterMetaData.class));
        clone.setState(this.state);
        clone.setType(this.type);
    }
}

