/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50.invocation;

import java.lang.reflect.Method;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.ws.WebServiceContext;
import org.jboss.wsf.common.JavaUtils;
import org.jboss.wsf.common.injection.InjectionHelper;
import org.jboss.wsf.common.injection.PreDestroyHolder;
import org.jboss.wsf.container.jboss50.invocation.ThreadLocalAwareWebServiceContext;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.Invocation;
import org.jboss.wsf.spi.invocation.InvocationContext;
import org.jboss.wsf.spi.invocation.InvocationHandler;
import org.jboss.wsf.spi.invocation.ResourceInjector;
import org.jboss.wsf.spi.invocation.ResourceInjectorFactory;
import org.jboss.wsf.spi.metadata.injection.InjectionsMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationHandlerJSE
extends InvocationHandler {
    private static final String POJO_JNDI_PREFIX = "java:comp/env/";
    private final ResourceInjectorFactory resourceInjectorFactory;

    public InvocationHandlerJSE() {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        this.resourceInjectorFactory = (ResourceInjectorFactory)spiProvider.getSPI(ResourceInjectorFactory.class);
    }

    public Invocation createInvocation() {
        return new Invocation();
    }

    public void init(Endpoint ep) {
    }

    protected Object getTargetBean(Endpoint ep, Invocation epInv) throws Exception {
        InvocationContext invCtx = epInv.getInvocationContext();
        Object targetBean = invCtx.getTargetBean();
        if (targetBean == null) {
            try {
                Class epImpl = ep.getTargetBeanClass();
                targetBean = epImpl.newInstance();
                invCtx.setTargetBean(targetBean);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot get target bean instance", ex);
            }
            ResourceInjector wsContextInjector = this.resourceInjectorFactory.newResourceInjector();
            wsContextInjector.inject(targetBean, (WebServiceContext)ThreadLocalAwareWebServiceContext.getInstance());
            InjectionsMetaData injectionsMD = (InjectionsMetaData)ep.getAttachment(InjectionsMetaData.class);
            if (injectionsMD != null) {
                InjectionHelper.injectResources((Object)targetBean, (InjectionsMetaData)injectionsMD, (Context)ep.getJNDIContext());
            }
            InjectionHelper.callPostConstructMethod((Object)targetBean);
            ep.addAttachment(PreDestroyHolder.class, (Object)new PreDestroyHolder(targetBean));
        }
        return targetBean;
    }

    public Context getJNDIContext(Endpoint ep) throws NamingException {
        return (Context)new InitialContext().lookup(POJO_JNDI_PREFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Endpoint ep, Invocation epInv) throws Exception {
        try {
            Object targetBean = this.getTargetBean(ep, epInv);
            InvocationContext invContext = epInv.getInvocationContext();
            WebServiceContext wsContext = (WebServiceContext)invContext.getAttachment(WebServiceContext.class);
            ThreadLocalAwareWebServiceContext.getInstance().setMessageContext(wsContext);
            Method method = this.getImplMethod(targetBean.getClass(), epInv.getJavaMethod());
            Object retObj = method.invoke(targetBean, epInv.getArgs());
            epInv.setReturnValue(retObj);
        }
        catch (Exception e) {
            this.handleInvocationException(e);
        }
        finally {
            ThreadLocalAwareWebServiceContext.getInstance().setMessageContext(null);
        }
    }

    protected Method getImplMethod(Class<?> implClass, Method seiMethod) throws ClassNotFoundException, NoSuchMethodException {
        String methodName = seiMethod.getName();
        Class<?>[] paramTypes = seiMethod.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            Class paramType = paramTypes[i];
            if (JavaUtils.isPrimitive(paramType)) continue;
            String paramTypeName = paramType.getName();
            paramTypes[i] = paramType = JavaUtils.loadJavaType((String)paramTypeName);
        }
        Method implMethod = implClass.getMethod(methodName, paramTypes);
        return implMethod;
    }
}

