/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.maven;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.util.maven.MavenArtifactNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenArtifactProperties {
    private static final Log LOG = LogFactory.getLog(MavenArtifactProperties.class);
    private static final Map<String, MavenArtifactProperties> INSTANCE_CACHE = new HashMap<String, MavenArtifactProperties>();
    private Properties props;
    private Set<String> propNames;

    private MavenArtifactProperties(Properties props) {
        this.props = props;
    }

    public String getGroupId() {
        return this.getProperty("groupId");
    }

    public String getArtifactId() {
        return this.getProperty("artifactId");
    }

    public String getVersion() {
        return this.getProperty("version");
    }

    public String getProperty(String propName) {
        return this.props.getProperty(propName);
    }

    public Set<String> getPropertyNames() {
        if (this.propNames == null) {
            this.propNames = new LinkedHashSet<String>(this.props.size());
            Set<Object> keys = this.props.keySet();
            for (Object key : keys) {
                this.propNames.add((String)key);
            }
        }
        return this.propNames;
    }

    public static MavenArtifactProperties getInstance(String groupId, String artifactId) throws MavenArtifactNotFoundException {
        MavenArtifactProperties instance;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            instance = MavenArtifactProperties.getInstance(groupId, artifactId, contextClassLoader);
        }
        catch (MavenArtifactNotFoundException e) {
            ClassLoader ourClassLoader = MavenArtifactProperties.class.getClassLoader();
            instance = MavenArtifactProperties.getInstance(groupId, artifactId, ourClassLoader);
        }
        return instance;
    }

    public static MavenArtifactProperties getInstance(String groupId, String artifactId, ClassLoader classLoader) throws MavenArtifactNotFoundException {
        String cacheKey = groupId + ":" + artifactId;
        MavenArtifactProperties instance = INSTANCE_CACHE.get(cacheKey);
        if (instance != null) {
            return instance;
        }
        String resourcePath = "META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties";
        InputStream inputStream = classLoader.getResourceAsStream(resourcePath);
        if (inputStream == null) {
            throw new MavenArtifactNotFoundException(cacheKey);
        }
        Properties props = new Properties();
        try {
            props.load(inputStream);
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to load resource " + resourcePath + " into Properties object."), (Throwable)e);
            return null;
        }
        instance = new MavenArtifactProperties(props);
        INSTANCE_CACHE.put(cacheKey, instance);
        return instance;
    }
}

