/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry.infomodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;
import org.apache.ws.scout.registry.infomodel.RegistryObjectImpl;
import org.apache.ws.scout.registry.infomodel.UserImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrganizationImpl
extends RegistryObjectImpl
implements Organization {
    private User primaryContact;
    private Set<User> users = new HashSet<User>();
    private Set<TelephoneNumber> telephoneNumbers = new HashSet<TelephoneNumber>();
    private Collection<Service> services = new ArrayList<Service>();

    public OrganizationImpl(LifeCycleManager lifeCycleManager) {
        super(lifeCycleManager);
    }

    public User getPrimaryContact() throws JAXRException {
        return this.primaryContact;
    }

    public void setPrimaryContact(User user) throws JAXRException {
        if (user == null) {
            throw new IllegalArgumentException("primaryContact must not be null");
        }
        this.primaryContact = user;
        if (!this.users.contains(user)) {
            this.addUser(user);
        }
    }

    public void addUser(User user) throws JAXRException {
        this.doPrimaryContactHack(user);
        this.users.add(user);
        ((UserImpl)user).setOrganization(this);
    }

    private void doPrimaryContactHack(User user) {
        if (this.primaryContact == null && this.users.size() == 0) {
            this.primaryContact = user;
        }
    }

    public void addUsers(Collection collection) throws JAXRException {
        for (User user : collection) {
            this.addUser(user);
        }
    }

    public Collection<User> getUsers() throws JAXRException {
        return this.users;
    }

    public void removeUser(User user) throws JAXRException {
        if (user != null) {
            this.users.remove(user);
        }
        if (!this.users.contains(this.primaryContact)) {
            this.primaryContact = null;
        }
    }

    public void removeUsers(Collection collection) throws JAXRException {
        if (collection != null) {
            this.users.removeAll(collection);
        }
        if (!this.users.contains(this.primaryContact)) {
            this.primaryContact = null;
        }
    }

    public Collection<TelephoneNumber> getTelephoneNumbers(String phoneType) throws JAXRException {
        Set<TelephoneNumber> filteredNumbers;
        if (phoneType == null) {
            filteredNumbers = this.telephoneNumbers;
        } else {
            filteredNumbers = new HashSet<TelephoneNumber>(this.telephoneNumbers.size());
            for (TelephoneNumber number : this.telephoneNumbers) {
                if (!phoneType.equals(number.getType())) continue;
                filteredNumbers.add(number);
            }
        }
        return filteredNumbers;
    }

    public void setTelephoneNumbers(Collection collection) throws JAXRException {
        HashSet<TelephoneNumber> numbers = new HashSet<TelephoneNumber>(collection.size());
        for (Object number : collection) {
            numbers.add((TelephoneNumber)number);
        }
        this.telephoneNumbers = numbers;
    }

    public void addService(Service service) throws JAXRException {
        this.services.add(service);
        service.setProvidingOrganization((Organization)this);
    }

    public void addServices(Collection collection) throws JAXRException {
        for (Service service : collection) {
            this.addService(service);
        }
    }

    public Collection<Service> getServices() throws JAXRException {
        return this.services;
    }

    public void removeService(Service service) throws JAXRException {
        this.services.remove(service);
    }

    public void removeServices(Collection collection) throws JAXRException {
        this.services.removeAll(collection);
    }

    public Organization getParentOrganization() throws JAXRException {
        throw new UnsupportedCapabilityException("Level 1 feature");
    }

    public Collection<Organization> getDescendantOrganizations() throws JAXRException {
        throw new UnsupportedCapabilityException("Level 1 feature");
    }

    public Organization getRootOrganization() throws JAXRException {
        throw new UnsupportedCapabilityException("Level 1 feature");
    }

    public void addChildOrganization(Organization organization) throws JAXRException {
        throw new UnsupportedCapabilityException("Level 1 feature");
    }

    public void addChildOrganizations(Collection collection) throws JAXRException {
        throw new UnsupportedCapabilityException("Level 1 feature");
    }

    public int getChildOrganizationCount() throws JAXRException {
        throw new UnsupportedCapabilityException("Level 1 feature");
    }

    public Collection<Organization> getChildOrganizations() throws JAXRException {
        throw new UnsupportedCapabilityException("Level 1 feature");
    }

    public void removeChildOrganization(Organization organization) throws JAXRException {
        throw new UnsupportedCapabilityException("Level 1 feature");
    }

    public void removeChildOrganizations(Collection collection) throws JAXRException {
        throw new UnsupportedCapabilityException("Level 1 feature");
    }

    public PostalAddress getPostalAddress() throws JAXRException {
        throw new UnsupportedCapabilityException("Level 1 feature");
    }

    public void setPostalAddress(PostalAddress postalAddress) throws JAXRException {
        throw new UnsupportedCapabilityException("Level 1 feature");
    }
}

