/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.util;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectUtils {
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static Pattern accessMethodPattern = Pattern.compile("access[$](\\d)+");

    public static Method[] getMethodsWithName(Class<?> clazz, String name) {
        Method[] methods = clazz.getMethods();
        return ReflectUtils.getMethodsWithName(methods, name);
    }

    public static Method[] getDeclaredMethodsWithName(Class<?> clazz, String name) {
        Method[] methods = clazz.getDeclaredMethods();
        return ReflectUtils.getMethodsWithName(methods, name);
    }

    private static Method[] getMethodsWithName(Method[] methods, String name) {
        ArrayList<Method> foundMethods = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name)) continue;
            foundMethods.add(methods[i]);
        }
        return foundMethods.toArray(new Method[foundMethods.size()]);
    }

    public static boolean isNotAccessMethod(Method m) {
        Matcher match;
        return !Modifier.isStatic(m.getModifiers()) || !(match = accessMethodPattern.matcher(m.getName())).matches();
    }

    public static <T> T[] copyArray(T[] original) {
        if (original == null) {
            return null;
        }
        Object[] copy = (Object[])Array.newInstance(original.getClass().getComponentType(), original.length);
        System.arraycopy(original, 0, copy, 0, copy.length);
        return copy;
    }

    public static int[] copyArray(int[] original) {
        if (original == null) {
            return null;
        }
        int[] copy = new int[original.length];
        System.arraycopy(original, 0, copy, 0, copy.length);
        return copy;
    }
}

