/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.publisher.PublisherID;
import org.apache.juddi.datatype.request.GetPublisherDetail;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class GetPublisherDetailHandler
extends AbstractHandler {
    public static final String TAG_NAME = "get_publisherDetail";
    private HandlerMaker maker = null;

    protected GetPublisherDetailHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        GetPublisherDetail obj = new GetPublisherDetail();
        Vector nodeList = null;
        AbstractHandler handler = null;
        String generic = element.getAttribute("generic");
        if (generic != null && generic.trim().length() > 0) {
            obj.setGeneric(generic);
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "publisherID");
        for (int i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("publisherID");
            obj.addPublisherID((PublisherID)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        GetPublisherDetail request = (GetPublisherDetail)object;
        String generic = request.getGeneric();
        generic = this.getGeneric(generic);
        String namespace = this.getUDDINamespace(generic);
        Element element = parent.getOwnerDocument().createElementNS(namespace, TAG_NAME);
        AbstractHandler handler = null;
        element.setAttribute("generic", generic);
        Vector idVector = request.getPublisherIDVector();
        if (idVector != null && idVector.size() > 0) {
            handler = this.maker.lookup("publisherID");
            for (int i = 0; i < idVector.size(); ++i) {
                handler.marshal(new PublisherID((String)idVector.elementAt(i)), element);
            }
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        GetPublisherDetail service = new GetPublisherDetail();
        service.addPublisherID("sviens");
        service.addPublisherID(new PublisherID("jdoe"));
        System.out.println();
        RegistryObject regObject = service;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

