/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.apt;

import java.io.IOException;
import java.io.PrintWriter;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;
import org.chromattic.api.PropertyLiteral;
import org.chromattic.apt.FormatterStyle;
import org.chromattic.apt.TypeFormatter;
import org.chromattic.metamodel.mapping.BeanMapping;
import org.chromattic.metamodel.mapping.PropertyMapping;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.TypeInfo;

class PropertyLiteralGenerator {
    private final BeanMapping beanMapping;

    PropertyLiteralGenerator(BeanMapping beanMapping) {
        this.beanMapping = beanMapping;
    }

    void build(Filer filer) throws IOException {
        String qualifiedName = this.beanMapping.getBean().getClassType().getName() + "_";
        JavaFileObject jfo = filer.createSourceFile(qualifiedName, new Element[0]);
        PrintWriter out = new PrintWriter(jfo.openWriter());
        this.build(out);
        out.close();
    }

    private void build(Appendable code) throws IOException {
        ClassTypeInfo owner = this.beanMapping.getBean().getClassType();
        code.append("package ").append(owner.getPackageName()).append(";\n");
        code.append("import ").append(PropertyLiteral.class.getName()).append(";\n");
        code.append("public class ").append(owner.getSimpleName()).append("_ {\n");
        for (PropertyMapping pm : this.beanMapping.getProperties().values()) {
            TypeInfo type = pm.getValue().getEffectiveType();
            StringBuilder toto = new StringBuilder();
            new TypeFormatter(owner, FormatterStyle.CAST, toto).format(type);
            code.append("public static final PropertyLiteral<").append(owner.getName()).append(",").append(toto).append("> ").append(pm.getName()).append(" = new PropertyLiteral<").append(owner.getName()).append(",").append(toto).append(">").append("(").append(owner.getName()).append(".class").append(",").append("\"").append(pm.getName()).append("\"").append(",").append(toto).append(".class").append(");\n");
        }
        code.append("}\n");
    }
}

