/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.core;

import java.util.ArrayList;
import java.util.List;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.GenericDeclarationInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.TypeVariableInfo;
import org.reflext.core.AbstractTypeInfo;
import org.reflext.core.TypeResolverImpl;
import org.reflext.spi.model.GenericDeclarationKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TypeVariableInfoImpl<T, M, A, P, F>
extends AbstractTypeInfo<T, M, A, P, F>
implements TypeVariableInfo {
    private final T type;
    private final String name;
    private GenericDeclarationInfo genericDeclaration;
    private List<TypeInfo> bounds;

    public TypeVariableInfoImpl(TypeResolverImpl<T, M, A, P, F> domain, T type) {
        super(domain);
        this.name = domain.typeModel.getName(type);
        this.type = type;
        this.genericDeclaration = null;
        this.bounds = null;
    }

    public boolean isReified() {
        return false;
    }

    public String getName() {
        List<TypeInfo> bounds = this.getBounds();
        if (bounds.isEmpty()) {
            return Object.class.getName();
        }
        return bounds.get(0).getName();
    }

    public T unwrap() {
        return this.type;
    }

    public List<TypeInfo> getBounds() {
        if (this.bounds == null) {
            ArrayList<TypeInfo> bounds = new ArrayList<TypeInfo>();
            for (Object b : this.domain.typeModel.getBounds(this.type)) {
                AbstractTypeInfo bound = this.domain._getType(b);
                bounds.add(bound);
            }
            this.bounds = bounds;
        }
        return this.bounds;
    }

    public GenericDeclarationInfo getGenericDeclaration() {
        if (this.genericDeclaration == null) {
            GenericDeclarationKind kind = this.domain.typeModel.getGenericDeclarationKind(this.type);
            switch (kind) {
                case TYPE: {
                    Object gd = this.domain.typeModel.getGenericDeclaration(this.type);
                    this.genericDeclaration = (ClassTypeInfo)this.domain.resolve(gd);
                    break;
                }
                case METHOD: {
                    Object mgd = this.domain.methodModel.getGenericDeclaration(this.type);
                    Object omgd = this.domain.methodModel.getOwner(mgd);
                    ClassTypeInfo tmp = (ClassTypeInfo)this.domain.resolve(omgd);
                    for (MethodInfo mi : tmp.getDeclaredMethods()) {
                        if (!mi.unwrap().equals(mgd)) continue;
                        this.genericDeclaration = mi;
                    }
                    if (this.genericDeclaration == null) {
                        throw new AssertionError((Object)"Need to handle that case which could happen due to covariant return types...");
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        return this.genericDeclaration;
    }

    public String getVariableName() {
        return this.name;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() ^ this.getGenericDeclaration().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TypeVariableInfo) {
            TypeVariableInfo that = (TypeVariableInfo)obj;
            GenericDeclarationInfo generidDeclaration = this.getGenericDeclaration();
            GenericDeclarationInfo thatGenericDeclaration = that.getGenericDeclaration();
            String thatName = that.getVariableName();
            return this.name.equals(thatName) && generidDeclaration.equals(thatGenericDeclaration);
        }
        return false;
    }

    public String toString() {
        return "TypeVariableInfo[name=" + this.name + "]";
    }
}

