/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql;

import java.lang.reflect.Constructor;
import org.hibernate.transform.AliasToBeanConstructorResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;

public final class HolderInstantiator {
    public static final HolderInstantiator NOOP_INSTANTIATOR = new HolderInstantiator(null, null);
    private final ResultTransformer transformer;
    private final String[] queryReturnAliases;

    public static HolderInstantiator getHolderInstantiator(ResultTransformer selectNewTransformer, ResultTransformer customTransformer, String[] queryReturnAliases) {
        if (selectNewTransformer != null) {
            return new HolderInstantiator(selectNewTransformer, queryReturnAliases);
        }
        return new HolderInstantiator(customTransformer, queryReturnAliases);
    }

    public static ResultTransformer createSelectNewTransformer(Constructor constructor, boolean returnMaps, boolean returnLists) {
        if (constructor != null) {
            return new AliasToBeanConstructorResultTransformer(constructor);
        }
        if (returnMaps) {
            return Transformers.ALIAS_TO_ENTITY_MAP;
        }
        if (returnLists) {
            return Transformers.TO_LIST;
        }
        return null;
    }

    public static HolderInstantiator createClassicHolderInstantiator(Constructor constructor, ResultTransformer transformer) {
        if (constructor != null) {
            return new HolderInstantiator(new AliasToBeanConstructorResultTransformer(constructor), null);
        }
        return new HolderInstantiator(transformer, null);
    }

    public HolderInstantiator(ResultTransformer transformer, String[] queryReturnAliases) {
        this.transformer = transformer;
        this.queryReturnAliases = queryReturnAliases;
    }

    public boolean isRequired() {
        return this.transformer != null;
    }

    public Object instantiate(Object[] row) {
        if (this.transformer == null) {
            return row;
        }
        return this.transformer.transformTuple(row, this.queryReturnAliases);
    }

    public String[] getQueryReturnAliases() {
        return this.queryReturnAliases;
    }

    public ResultTransformer getResultTransformer() {
        return this.transformer;
    }
}

