/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.mop.core.api.workspace.content;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.chromattic.api.RelationshipType;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.Name;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.PrimaryType;
import org.gatein.mop.api.content.CustomizationContext;
import org.gatein.mop.api.workspace.WorkspaceCustomizationContext;
import org.gatein.mop.core.api.workspace.content.AbstractCustomization;
import org.gatein.mop.core.api.workspace.content.WorkspaceCustomization;
import org.gatein.mop.core.api.workspace.content.WorkspaceSpecialization;

@PrimaryType(name="mop:workspaceclone")
public abstract class WorkspaceClone
extends WorkspaceCustomization {
    @Override
    public Set<CustomizationContext> getContexts() {
        return Collections.emptySet();
    }

    @Name
    public abstract String getFooName();

    @OneToMany(type=RelationshipType.PATH)
    @MappedBy(value="mop:customization")
    public abstract Collection<WorkspaceSpecialization> getSpecializations();

    public String getName() {
        CustomizationContext customizationContext = this.getContext();
        if (customizationContext instanceof WorkspaceCustomizationContext) {
            return this.getFooName();
        }
        return null;
    }

    @Override
    public AbstractCustomization getParent() {
        return null;
    }

    public void destroy() {
        ArrayList<WorkspaceSpecialization> specializations = new ArrayList<WorkspaceSpecialization>(this.getSpecializations());
        for (WorkspaceSpecialization specialization : specializations) {
            Object state = specialization.getVirtualState();
            specialization.setState(state);
            specialization.setCustomization(null);
        }
        this.doDestroy();
    }
}

