/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.auth;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.crypto.Cipher;
import org.jgroups.Message;
import org.jgroups.auth.AuthToken;
import org.jgroups.util.Util;

public class X509Token
extends AuthToken {
    public static final String KEYSTORE_TYPE = "keystore_type";
    public static final String KEYSTORE_PATH = "keystore_path";
    public static final String KEYSTORE_PASSWORD = "keystore_password";
    public static final String CERT_ALIAS = "cert_alias";
    public static final String CERT_PASSWORD = "cert_password";
    public static final String TOKEN_ATTR = "auth_value";
    public static final String CIPHER_TYPE = "cipher_type";
    private boolean valueSet = false;
    private String keystore_type = null;
    private String cert_alias = null;
    private String keystore_path = null;
    private String token_attr = null;
    private String cipher_type = null;
    private byte[] encryptedToken = null;
    private char[] cert_password = null;
    private char[] keystore_password = null;
    private Cipher cipher = null;
    private PrivateKey certPrivateKey = null;
    private X509Certificate certificate = null;
    private static final long serialVersionUID = 5479828159290223720L;

    @Override
    public void setValue(Properties properties) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"setting values on X509Token object");
        }
        if (properties.containsKey(TOKEN_ATTR)) {
            this.token_attr = (String)properties.get(TOKEN_ATTR);
            properties.remove(TOKEN_ATTR);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("token_attr = " + this.token_attr));
            }
        }
        if (properties.containsKey(KEYSTORE_TYPE)) {
            this.keystore_type = (String)properties.get(KEYSTORE_TYPE);
            properties.remove(KEYSTORE_TYPE);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("keystore_type = " + this.keystore_type));
            }
        } else {
            this.keystore_type = "JKS";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("keystore_type = " + this.keystore_type));
            }
        }
        if (properties.containsKey(KEYSTORE_PATH)) {
            this.keystore_path = (String)properties.get(KEYSTORE_PATH);
            properties.remove(KEYSTORE_PATH);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("keystore_path = " + this.keystore_path));
            }
        }
        if (properties.containsKey(KEYSTORE_PASSWORD)) {
            this.keystore_password = ((String)properties.get(KEYSTORE_PASSWORD)).toCharArray();
            properties.remove(KEYSTORE_PASSWORD);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("keystore_password = " + this.keystore_password));
            }
        }
        if (properties.containsKey(CERT_ALIAS)) {
            this.cert_alias = (String)properties.get(CERT_ALIAS);
            properties.remove(CERT_ALIAS);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("cert_alias = " + this.cert_alias));
            }
        }
        if (properties.containsKey(CERT_PASSWORD)) {
            this.cert_password = ((String)properties.get(CERT_PASSWORD)).toCharArray();
            properties.remove(CERT_PASSWORD);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("cert_password = " + this.cert_password));
            }
        } else {
            this.cert_password = this.keystore_password;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("cert_password = " + this.cert_password));
            }
        }
        if (properties.containsKey(CIPHER_TYPE)) {
            this.cipher_type = (String)properties.get(CIPHER_TYPE);
            properties.remove(CIPHER_TYPE);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("cipher_type = " + this.cipher_type));
            }
        } else {
            this.cipher_type = "RSA";
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("cipher_type = " + this.cipher_type));
            }
        }
        if (this.getCertificate()) {
            this.valueSet = true;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"X509Token created correctly");
            }
        }
    }

    @Override
    public String getName() {
        return "org.jgroups.auth.X509Token";
    }

    @Override
    public boolean authenticate(AuthToken token, Message msg) {
        block11: {
            if (!this.valueSet) {
                if (this.log.isFatalEnabled()) {
                    this.log.fatal((Object)"X509Token not setup correctly - check token attrs");
                }
                return false;
            }
            if (token != null && token instanceof X509Token) {
                X509Token serverToken = (X509Token)token;
                if (!serverToken.valueSet) {
                    if (this.log.isFatalEnabled()) {
                        this.log.fatal((Object)"X509Token - recieved token not valid");
                    }
                    return false;
                }
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"setting cipher to decrypt mode");
                    }
                    this.cipher.init(2, this.certPrivateKey);
                    String serverBytes = new String(this.cipher.doFinal(serverToken.encryptedToken));
                    if (serverBytes != null && serverBytes.equalsIgnoreCase(this.token_attr)) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"X509 authentication passed");
                        }
                        return true;
                    }
                }
                catch (Exception e) {
                    if (!this.log.isFatalEnabled()) break block11;
                    this.log.fatal((Object)e);
                }
            }
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)"X509 authentication failed");
        }
        return false;
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"X509Token writeTo()");
        }
        Util.writeByteBuffer(this.encryptedToken, out);
    }

    @Override
    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"X509Token readFrom()");
        }
        this.encryptedToken = Util.readByteBuffer(in);
        this.valueSet = true;
    }

    private boolean getCertificate() {
        try {
            KeyStore store = KeyStore.getInstance(this.keystore_type);
            FileInputStream fis = new FileInputStream(this.keystore_path);
            store.load(fis, this.keystore_password);
            this.cipher = Cipher.getInstance(this.cipher_type);
            this.certificate = (X509Certificate)store.getCertificate(this.cert_alias);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("certificate = " + this.certificate.toString()));
            }
            this.cipher.init(1, this.certificate);
            this.encryptedToken = this.cipher.doFinal(this.token_attr.getBytes());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("encryptedToken = " + this.encryptedToken));
            }
            KeyStore.PrivateKeyEntry privateKey = (KeyStore.PrivateKeyEntry)store.getEntry(this.cert_alias, new KeyStore.PasswordProtection(this.cert_password));
            this.certPrivateKey = privateKey.getPrivateKey();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("certPrivateKey = " + this.certPrivateKey.toString()));
            }
            return true;
        }
        catch (Exception e) {
            if (this.log.isFatalEnabled()) {
                this.log.fatal((Object)e);
            }
            return false;
        }
    }
}

