/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.DefaultStyledDocument;
import org.exoplatform.swing.Application;
import org.exoplatform.swing.JExoToolBar;
import org.exoplatform.swing.Workspaces;

public class JExoTextEditor
extends JPanel {
    protected DefaultStyledDocument document_ = new DefaultStyledDocument();
    protected JTextPane textPane_ = new JTextPane(this.document_);
    protected JExoToolBar toolBar_ = new JExoToolBar();
    protected JScrollPane scrollPane;

    public JExoTextEditor() {
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this.textPane_);
        this.scrollPane.setViewportView(this.textPane_);
        JButton btnNew = new JButton("New");
        this.toolBar_.addButton(btnNew);
        JButton btnOpen = new JButton("Open");
        this.toolBar_.addButton(btnOpen);
        JButton btnSave = new JButton("Save");
        this.toolBar_.addButton(btnSave);
        btnNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    JInternalFrame frame = Application.getInstance().getWorkspaces().openFrame("New");
                    JExoTextEditor textEditor = new JExoTextEditor();
                    frame.add(textEditor);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        btnSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JExoTextEditor.this.saveFile();
            }
        });
        btnOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JExoTextEditor.this.OpenFileToolbar();
            }
        });
        this.addComponents();
    }

    public void addComponents() {
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.toolBar_, "North");
    }

    public JExoTextEditor(String text) {
        this();
        this.setVisible(true);
        this.textPane_.setText(text);
    }

    public JExoToolBar getToobar() {
        return this.toolBar_;
    }

    public void OpenFileToolbar() {
        JFileChooser fileChooser = new JFileChooser();
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fileChooser.getSelectedFile();
            try {
                this.opentFile(file.getPath());
                Workspaces workspaces = Application.getInstance().getWorkspaces();
                Map<String, Workspaces.ViewFrame> frames = workspaces.getOpenFrames();
                Object[] objFrames = frames.values().toArray();
                Workspaces.ViewFrame[] viewFrames = new Workspaces.ViewFrame[objFrames.length];
                for (int i = 0; i < objFrames.length; ++i) {
                    viewFrames[i] = (Workspaces.ViewFrame)objFrames[i];
                    if (!viewFrames[i].isSelected()) continue;
                    viewFrames[i].setTitle(file.getPath());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void opentFile(String filePath) throws Exception {
        int read;
        FileInputStream is = new FileInputStream(filePath);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buf = new byte[4092];
        while ((read = is.read(buf)) >= 0) {
            os.write(buf, 0, read);
        }
        this.textPane_.setText(new String(os.toByteArray()));
    }

    public String getText() {
        return this.textPane_.getText();
    }

    public void setText(String text) {
        this.textPane_.setText(text);
    }

    private void saveFile() {
        JFileChooser fileChooser = new JFileChooser();
        int returnVal = fileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            File file = fileChooser.getSelectedFile();
            try {
                this.textPane_.write(new FileWriter(file));
            }
            catch (IOException exp) {
                exp.printStackTrace();
            }
        }
    }
}

